/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.Pair;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.api.directions.v5.models.LegAnnotation;
import com.mapbox.api.directions.v5.models.LegStep;
import com.mapbox.api.directions.v5.models.MaxSpeed;
import com.mapbox.api.directions.v5.models.RouteLeg;
import com.mapbox.api.directions.v5.models.StepIntersection;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.utils.PolylineUtils;
import com.mapbox.services.android.navigation.v5.milestone.Milestone;
import com.mapbox.services.android.navigation.v5.routeprogress.CurrentLegAnnotation;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import com.mapbox.turf.TurfMeasurement;
import com.mapbox.turf.TurfMisc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NavigationHelper {
    private static final int FIRST_POINT = 0;
    private static final int FIRST_INTERSECTION = 0;
    private static final int ONE_INDEX = 1;
    private static final int INDEX_ZERO = 0;
    private static final String EMPTY_STRING = "";
    private static final double ZERO_METERS = 0.0;
    private static final int TWO_POINTS = 2;

    private NavigationHelper() {
    }

    static String buildInstructionString(RouteProgress routeProgress, Milestone milestone) {
        if (milestone.getInstruction() != null) {
            return milestone.getInstruction().buildInstruction(routeProgress);
        }
        return EMPTY_STRING;
    }

    static double routeDistanceRemaining(double legDistanceRemaining, int legIndex, DirectionsRoute directionsRoute) {
        if (directionsRoute.legs().size() < 2) {
            return legDistanceRemaining;
        }
        for (int i = legIndex + 1; i < directionsRoute.legs().size(); ++i) {
            legDistanceRemaining += ((RouteLeg)directionsRoute.legs().get(i)).distance().doubleValue();
        }
        return legDistanceRemaining;
    }

    static List<Point> decodeStepPoints(DirectionsRoute directionsRoute, List<Point> currentPoints, int legIndex, int stepIndex) {
        boolean invalidStepIndex;
        List legs = directionsRoute.legs();
        if (NavigationHelper.hasInvalidLegs(legs)) {
            return currentPoints;
        }
        List steps = ((RouteLeg)legs.get(legIndex)).steps();
        if (NavigationHelper.hasInvalidSteps(steps)) {
            return currentPoints;
        }
        boolean bl = invalidStepIndex = stepIndex < 0 || stepIndex > steps.size() - 1;
        if (invalidStepIndex) {
            return currentPoints;
        }
        LegStep step = (LegStep)steps.get(stepIndex);
        if (step == null) {
            return currentPoints;
        }
        String stepGeometry = step.geometry();
        if (stepGeometry != null) {
            return PolylineUtils.decode((String)stepGeometry, (int)6);
        }
        return currentPoints;
    }

    @NonNull
    public static List<StepIntersection> createIntersectionsList(@NonNull LegStep currentStep, LegStep upcomingStep) {
        ArrayList<StepIntersection> intersectionsWithNextManeuver = new ArrayList<StepIntersection>();
        intersectionsWithNextManeuver.addAll(currentStep.intersections());
        if (upcomingStep != null && !upcomingStep.intersections().isEmpty()) {
            intersectionsWithNextManeuver.add((StepIntersection)upcomingStep.intersections().get(0));
        }
        return intersectionsWithNextManeuver;
    }

    @NonNull
    public static List<Pair<StepIntersection, Double>> createDistancesToIntersections(List<Point> stepPoints, List<StepIntersection> intersections) {
        boolean lessThanTwoStepPoints = stepPoints.size() < 2;
        boolean noIntersections = intersections.isEmpty();
        if (lessThanTwoStepPoints || noIntersections) {
            return Collections.emptyList();
        }
        LineString stepLineString = LineString.fromLngLats(stepPoints);
        Point firstStepPoint = stepPoints.get(0);
        ArrayList<Pair<StepIntersection, Double>> distancesToIntersections = new ArrayList<Pair<StepIntersection, Double>>();
        for (StepIntersection intersection : intersections) {
            Point intersectionPoint = intersection.location();
            if (firstStepPoint.equals((Object)intersectionPoint)) {
                distancesToIntersections.add((Pair<StepIntersection, Double>)new Pair((Object)intersection, (Object)0.0));
                continue;
            }
            LineString beginningLineString = TurfMisc.lineSlice((Point)firstStepPoint, (Point)intersectionPoint, (LineString)stepLineString);
            double distanceToIntersectionInMeters = TurfMeasurement.length((LineString)beginningLineString, (String)"meters");
            distancesToIntersections.add((Pair<StepIntersection, Double>)new Pair((Object)intersection, (Object)distanceToIntersectionInMeters));
        }
        return distancesToIntersections;
    }

    public static StepIntersection findCurrentIntersection(@NonNull List<StepIntersection> intersections, @NonNull List<Pair<StepIntersection, Double>> measuredIntersections, double stepDistanceTraveled) {
        for (Pair<StepIntersection, Double> measuredIntersection : measuredIntersections) {
            int measuredIntersectionSize;
            boolean hasValidNextIntersection;
            double intersectionDistance = (Double)measuredIntersection.second;
            int intersectionIndex = measuredIntersections.indexOf(measuredIntersection);
            int nextIntersectionIndex = intersectionIndex + 1;
            boolean bl = hasValidNextIntersection = nextIntersectionIndex < (measuredIntersectionSize = measuredIntersections.size());
            if (hasValidNextIntersection) {
                double nextIntersectionDistance = (Double)measuredIntersections.get((int)nextIntersectionIndex).second;
                if (!(stepDistanceTraveled > intersectionDistance) || !(stepDistanceTraveled < nextIntersectionDistance)) continue;
                return (StepIntersection)measuredIntersection.first;
            }
            if (stepDistanceTraveled > (Double)measuredIntersection.second) {
                return (StepIntersection)measuredIntersection.first;
            }
            return (StepIntersection)measuredIntersections.get((int)0).first;
        }
        return intersections.get(0);
    }

    public static StepIntersection findUpcomingIntersection(@NonNull List<StepIntersection> intersections, @Nullable LegStep upcomingStep, StepIntersection currentIntersection) {
        List upcomingIntersections;
        int intersectionSize;
        boolean isValidUpcomingIntersection;
        int intersectionIndex = intersections.indexOf(currentIntersection);
        int nextIntersectionIndex = intersectionIndex + 1;
        boolean bl = isValidUpcomingIntersection = nextIntersectionIndex < (intersectionSize = intersections.size());
        if (isValidUpcomingIntersection) {
            return intersections.get(nextIntersectionIndex);
        }
        if (upcomingStep != null && (upcomingIntersections = upcomingStep.intersections()) != null && !upcomingIntersections.isEmpty()) {
            return (StepIntersection)upcomingIntersections.get(0);
        }
        return null;
    }

    @Nullable
    public static CurrentLegAnnotation createCurrentAnnotation(CurrentLegAnnotation currentLegAnnotation, RouteLeg leg, double legDistanceRemaining) {
        List congestionList;
        List maxspeedList;
        List speedList;
        LegAnnotation legAnnotation = leg.annotation();
        if (legAnnotation == null) {
            return null;
        }
        List distanceList = legAnnotation.distance();
        if (distanceList == null || distanceList.isEmpty()) {
            return null;
        }
        CurrentLegAnnotation.Builder annotationBuilder = CurrentLegAnnotation.builder();
        int annotationIndex = NavigationHelper.findAnnotationIndex(currentLegAnnotation, annotationBuilder, leg, legDistanceRemaining, distanceList);
        annotationBuilder.distance((Double)distanceList.get(annotationIndex));
        List durationList = legAnnotation.duration();
        if (durationList != null) {
            annotationBuilder.duration((Double)durationList.get(annotationIndex));
        }
        if ((speedList = legAnnotation.speed()) != null) {
            annotationBuilder.speed((Double)speedList.get(annotationIndex));
        }
        if ((maxspeedList = legAnnotation.maxspeed()) != null) {
            annotationBuilder.maxspeed((MaxSpeed)maxspeedList.get(annotationIndex));
        }
        if ((congestionList = legAnnotation.congestion()) != null) {
            annotationBuilder.congestion((String)congestionList.get(annotationIndex));
        }
        annotationBuilder.index(annotationIndex);
        return annotationBuilder.build();
    }

    private static int findAnnotationIndex(CurrentLegAnnotation currentLegAnnotation, CurrentLegAnnotation.Builder annotationBuilder, RouteLeg leg, double legDistanceRemaining, List<Double> distanceAnnotationList) {
        ArrayList<Double> legDistances = new ArrayList<Double>(distanceAnnotationList);
        Double totalLegDistance = leg.distance();
        double distanceTraveled = totalLegDistance - legDistanceRemaining;
        int distanceIndex = 0;
        double annotationDistancesTraveled = 0.0;
        if (currentLegAnnotation != null) {
            distanceIndex = currentLegAnnotation.index();
            annotationDistancesTraveled = currentLegAnnotation.distanceToAnnotation();
        }
        for (int i = distanceIndex; i < legDistances.size(); ++i) {
            Double distance = (Double)legDistances.get(i);
            if (!((annotationDistancesTraveled += distance.doubleValue()) > distanceTraveled)) continue;
            double distanceToAnnotation = annotationDistancesTraveled - distance;
            annotationBuilder.distanceToAnnotation(distanceToAnnotation);
            return i;
        }
        return 0;
    }

    private static boolean hasInvalidLegs(List<RouteLeg> legs) {
        return legs == null || legs.isEmpty();
    }

    private static boolean hasInvalidSteps(List<LegStep> steps) {
        return steps == null || steps.isEmpty();
    }
}

