/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import com.mapbox.core.utils.TextUtils;
import com.mapbox.services.android.navigation.v5.navigation.ElapsedTime;
import com.mapbox.services.android.navigation.v5.navigation.InitialGpsEventHandler;

class InitialGpsEventFactory {
    private static final String EMPTY_STRING = "";
    private String sessionId = "";
    private ElapsedTime time;
    private InitialGpsEventHandler handler;
    private boolean hasSent;

    InitialGpsEventFactory() {
        this(new ElapsedTime(), new InitialGpsEventHandler());
    }

    InitialGpsEventFactory(ElapsedTime time, InitialGpsEventHandler handler) {
        this.time = time;
        this.handler = handler;
    }

    void navigationStarted(String sessionId) {
        this.sessionId = sessionId;
        this.time.start();
    }

    void gpsReceived() {
        if (this.time.getStart() == null) {
            return;
        }
        this.time.end();
        this.send(this.time);
    }

    void reset() {
        this.time = new ElapsedTime();
        this.hasSent = false;
    }

    private void send(ElapsedTime time) {
        if (!this.hasSent && !TextUtils.isEmpty((CharSequence)this.sessionId)) {
            double elapsedTime = time.getElapsedTime();
            this.handler.send(elapsedTime, this.sessionId);
            this.hasSent = true;
        }
    }
}

