/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.support.annotation.Nullable;
import com.mapbox.services.android.navigation.v5.exception.NavigationException;

class ElapsedTime {
    private static final double ELAPSED_TIME_DENOMINATOR = 1.0E9;
    private static final double PRECISION = 100.0;
    private Long start = null;
    private Long end = null;

    ElapsedTime() {
    }

    void start() {
        this.start = System.nanoTime();
    }

    @Nullable
    Long getStart() {
        return this.start;
    }

    void end() {
        if (this.start == null) {
            throw new NavigationException("Must call start() before calling end()");
        }
        this.end = System.nanoTime();
    }

    @Nullable
    Long getEnd() {
        return this.end;
    }

    double getElapsedTime() {
        if (this.start == null || this.end == null) {
            throw new NavigationException("Must call start() and end() before calling getElapsedTime()");
        }
        long elapsedTimeInNanoseconds = this.end - this.start;
        double elapsedTimeInSeconds = (double)elapsedTimeInNanoseconds / 1.0E9;
        return (double)Math.round(elapsedTimeInSeconds * 100.0) / 100.0;
    }
}

