/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.utils;

import com.mapbox.api.directions.v5.models.LegStep;
import com.mapbox.core.utils.TextUtils;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.Point;
import com.mapbox.turf.TurfMeasurement;
import com.mapbox.turf.TurfMisc;
import java.util.List;

public final class MeasurementUtils {
    private MeasurementUtils() {
        throw new AssertionError((Object)"No Instance.");
    }

    public static double userTrueDistanceFromStep(Point usersRawLocation, LegStep step) {
        if (TextUtils.isEmpty((CharSequence)step.geometry())) {
            return 0.0;
        }
        LineString lineString = LineString.fromPolyline((String)step.geometry(), (int)6);
        if (lineString.coordinates().isEmpty() || usersRawLocation.equals(lineString.coordinates().get(0))) {
            return 0.0;
        }
        if (lineString.coordinates().size() == 1) {
            return TurfMeasurement.distance((Point)usersRawLocation, (Point)((Point)lineString.coordinates().get(0)), (String)"meters");
        }
        Feature feature = TurfMisc.nearestPointOnLine((Point)usersRawLocation, (List)lineString.coordinates());
        Point snappedPoint = (Point)feature.geometry();
        if (snappedPoint == null) {
            return 0.0;
        }
        if (Double.isInfinite(snappedPoint.latitude()) || Double.isInfinite(snappedPoint.longitude())) {
            return TurfMeasurement.distance((Point)usersRawLocation, (Point)((Point)lineString.coordinates().get(0)), (String)"meters");
        }
        double distance = TurfMeasurement.distance((Point)usersRawLocation, (Point)snappedPoint, (String)"meters");
        return Double.isNaN(distance) ? 0.0 : distance;
    }
}

