/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.utils;

import android.os.AsyncTask;
import android.support.annotation.NonNull;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import okhttp3.ResponseBody;

public class DownloadTask
extends AsyncTask<ResponseBody, Void, File> {
    private static final int END_OF_FILE_DENOTER = -1;
    private static int uniqueId = 0;
    private final String destDirectory;
    private final DownloadListener downloadListener;
    private final String extension;
    private final String fileName;

    public DownloadTask(String destDirectory, String extension, DownloadListener downloadListener) {
        this(destDirectory, "", extension, downloadListener);
    }

    public DownloadTask(String destDirectory, String fileName, String extension, DownloadListener downloadListener) {
        this.destDirectory = destDirectory;
        this.fileName = fileName;
        this.extension = extension;
        this.downloadListener = downloadListener;
    }

    protected File doInBackground(ResponseBody ... responseBodies) {
        return this.saveAsFile(responseBodies[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File saveAsFile(ResponseBody responseBody) {
        if (responseBody == null) {
            return null;
        }
        try {
            File file = new File(this.destDirectory + File.separator + this.fileName + this.retrieveUniqueId() + "." + this.extension);
            InputStream inputStream = null;
            FileOutputStream outputStream = null;
            try {
                int numOfBufferedBytes;
                inputStream = responseBody.byteStream();
                outputStream = new FileOutputStream(file);
                byte[] buffer = new byte[4096];
                while ((numOfBufferedBytes = inputStream.read(buffer)) != -1) {
                    ((OutputStream)outputStream).write(buffer, 0, numOfBufferedBytes);
                }
                outputStream.flush();
                File file2 = file;
                return file2;
            }
            catch (IOException exception) {
                File file3 = null;
                return file3;
            }
            catch (Exception exception) {
                File file4 = null;
                return file4;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    ((OutputStream)outputStream).close();
                }
            }
        }
        catch (IOException exception) {
            return null;
        }
    }

    private String retrieveUniqueId() {
        return uniqueId++ > 0 ? "" + uniqueId : "";
    }

    protected void onPostExecute(File instructionFile) {
        if (this.downloadListener == null) {
            return;
        }
        if (instructionFile == null) {
            this.downloadListener.onErrorDownloading();
        } else {
            this.downloadListener.onFinishedDownloading(instructionFile);
        }
    }

    public static interface DownloadListener {
        public void onFinishedDownloading(@NonNull File var1);

        public void onErrorDownloading();
    }
}

