/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.app.Application;
import android.content.Context;
import android.location.Location;
import android.support.annotation.NonNull;
import com.mapbox.android.core.location.LocationEngine;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.TelemetryUtils;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.core.utils.TextUtils;
import com.mapbox.geojson.utils.PolylineUtils;
import com.mapbox.services.android.navigation.v5.exception.NavigationException;
import com.mapbox.services.android.navigation.v5.location.MetricsLocation;
import com.mapbox.services.android.navigation.v5.navigation.BatteryChargeReporter;
import com.mapbox.services.android.navigation.v5.navigation.BatteryEvent;
import com.mapbox.services.android.navigation.v5.navigation.BatteryMonitor;
import com.mapbox.services.android.navigation.v5.navigation.ElapsedTime;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigation;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigationOptions;
import com.mapbox.services.android.navigation.v5.navigation.NavigationEventDispatcher;
import com.mapbox.services.android.navigation.v5.navigation.NavigationLifecycleMonitor;
import com.mapbox.services.android.navigation.v5.navigation.NavigationMetricsWrapper;
import com.mapbox.services.android.navigation.v5.navigation.metrics.FeedbackEvent;
import com.mapbox.services.android.navigation.v5.navigation.metrics.NavigationMetricListener;
import com.mapbox.services.android.navigation.v5.navigation.metrics.RerouteEvent;
import com.mapbox.services.android.navigation.v5.navigation.metrics.SessionState;
import com.mapbox.services.android.navigation.v5.navigation.metrics.TelemetryEvent;
import com.mapbox.services.android.navigation.v5.routeprogress.MetricsRouteProgress;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import com.mapbox.services.android.navigation.v5.utils.RingBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;

class NavigationTelemetry
implements NavigationMetricListener {
    private Context context;
    private static NavigationTelemetry instance;
    private boolean isInitialized = false;
    private static final String MAPBOX_NAVIGATION_SDK_IDENTIFIER = "mapbox-navigation-android";
    private static final String MAPBOX_NAVIGATION_UI_SDK_IDENTIFIER = "mapbox-navigation-ui-android";
    private static final String MOCK_PROVIDER = "com.mapbox.services.android.navigation.v5.location.replay.ReplayRouteLocationEngine";
    private static final int TWENTY_SECOND_INTERVAL = 20;
    private static final int ONE_MINUTE_IN_MILLISECONDS = 60000;
    private final List<RerouteEvent> queuedRerouteEvents = new ArrayList<RerouteEvent>();
    private final List<FeedbackEvent> queuedFeedbackEvents = new ArrayList<FeedbackEvent>();
    private MetricsRouteProgress metricProgress;
    private MetricsLocation metricLocation;
    private NavigationEventDispatcher eventDispatcher;
    private NavigationLifecycleMonitor lifecycleMonitor;
    private SessionState navigationSessionState;
    private RingBuffer<Location> locationBuffer = new RingBuffer(40);
    private Date lastRerouteDate;
    private boolean isOffRoute;
    private boolean isConfigurationChange;
    private ElapsedTime routeRetrievalElapsedTime = null;
    private String routeRetrievalUuid = null;
    private BatteryChargeReporter batteryChargeReporter;

    NavigationTelemetry() {
        this.metricLocation = new MetricsLocation(null);
        this.metricProgress = new MetricsRouteProgress(null);
        this.navigationSessionState = SessionState.builder().build();
    }

    public static synchronized NavigationTelemetry getInstance() {
        if (instance == null) {
            instance = new NavigationTelemetry();
        }
        return instance;
    }

    @Override
    public void onRouteProgressUpdate(RouteProgress routeProgress) {
        boolean isValidDeparture;
        this.metricProgress = new MetricsRouteProgress(routeProgress);
        boolean bl = isValidDeparture = this.navigationSessionState.startTimestamp() == null && routeProgress.currentLegProgress().distanceTraveled() > 0.0;
        if (isValidDeparture) {
            this.navigationSessionState = this.navigationSessionState.toBuilder().startTimestamp(new Date()).build();
            this.updateLifecyclePercentages();
            NavigationMetricsWrapper.departEvent(this.navigationSessionState, this.metricProgress, this.metricLocation.getLocation(), this.context);
        }
    }

    @Override
    public void onOffRouteEvent(Location offRouteLocation) {
        if (!this.isOffRoute) {
            this.updateDistanceCompleted();
            this.queueRerouteEvent();
            this.isOffRoute = true;
        }
    }

    @Override
    public void onArrival(RouteProgress routeProgress) {
        this.navigationSessionState = this.navigationSessionState.toBuilder().arrivalTimestamp(new Date()).tripIdentifier(TelemetryUtils.obtainUniversalUniqueIdentifier()).build();
        this.updateLifecyclePercentages();
        NavigationMetricsWrapper.arriveEvent(this.navigationSessionState, routeProgress, this.metricLocation.getLocation(), this.context);
    }

    void initialize(@NonNull Context context, @NonNull String accessToken, MapboxNavigation navigation, LocationEngine locationEngine) {
        if (!this.isInitialized) {
            String sdkIdentifier;
            this.updateLocationEngineName(locationEngine);
            this.validateAccessToken(accessToken);
            this.context = context;
            NavigationMetricsWrapper.init(context, accessToken, "mapbox-navigation-android/0.31.0-SNAPSHOT");
            MapboxNavigationOptions options = navigation.options();
            NavigationMetricsWrapper.sdkIdentifier = sdkIdentifier = this.obtainSdkIdentifier(options);
            NavigationMetricsWrapper.toggleLogging(options.isDebugLoggingEnabled());
            Event navTurnstileEvent = NavigationMetricsWrapper.turnstileEvent();
            NavigationMetricsWrapper.push(navTurnstileEvent);
            this.isInitialized = true;
        }
        this.initEventDispatcherListeners(navigation);
    }

    void initializeLifecycleMonitor(Application application) {
        if (this.lifecycleMonitor == null) {
            this.lifecycleMonitor = new NavigationLifecycleMonitor(application);
        }
    }

    void startSession(DirectionsRoute directionsRoute) {
        if (!this.isConfigurationChange) {
            this.navigationSessionState = this.navigationSessionState.toBuilder().sessionIdentifier(TelemetryUtils.obtainUniversalUniqueIdentifier()).tripIdentifier(TelemetryUtils.obtainUniversalUniqueIdentifier()).originalDirectionRoute(directionsRoute).originalRequestIdentifier(directionsRoute.routeOptions().requestUuid()).requestIdentifier(directionsRoute.routeOptions().requestUuid()).currentDirectionRoute(directionsRoute).eventRouteDistanceCompleted(0.0).mockLocation(this.metricLocation.getLocation().getProvider().equals(MOCK_PROVIDER)).rerouteCount(0).build();
        }
        this.isConfigurationChange = false;
        this.sendRouteRetrievalEventIfExists();
        this.fireOffBatteryScheduler();
    }

    private void sendRouteRetrievalEventIfExists() {
        if (this.routeRetrievalElapsedTime != null) {
            this.routeRetrievalEvent(this.routeRetrievalElapsedTime, this.routeRetrievalUuid);
            this.routeRetrievalElapsedTime = null;
            this.routeRetrievalUuid = null;
        }
    }

    void endSession(boolean isConfigurationChange) {
        this.isConfigurationChange = isConfigurationChange;
        if (!isConfigurationChange) {
            if (this.navigationSessionState.startTimestamp() != null) {
                this.flushEventQueues();
                this.updateLifecyclePercentages();
                NavigationMetricsWrapper.cancelEvent(this.navigationSessionState, this.metricProgress, this.metricLocation.getLocation(), this.context);
            }
            this.lifecycleMonitor = null;
            NavigationMetricsWrapper.disable();
            this.isInitialized = false;
        }
        this.cancelBatteryScheduler();
    }

    void updateSessionRoute(DirectionsRoute directionsRoute) {
        SessionState.Builder navigationBuilder = this.navigationSessionState.toBuilder().tripIdentifier(TelemetryUtils.obtainUniversalUniqueIdentifier());
        navigationBuilder.currentDirectionRoute(directionsRoute);
        this.eventDispatcher.addMetricEventListeners(this);
        if (this.isOffRoute) {
            navigationBuilder.rerouteCount(this.navigationSessionState.rerouteCount() + 1);
            boolean hasRouteOptions = directionsRoute.routeOptions() != null;
            navigationBuilder.requestIdentifier(hasRouteOptions ? directionsRoute.routeOptions().requestUuid() : null);
            this.navigationSessionState = navigationBuilder.build();
            this.updateLastRerouteEvent(directionsRoute);
            this.lastRerouteDate = new Date();
            this.isOffRoute = false;
        } else {
            this.navigationSessionState = navigationBuilder.build();
        }
    }

    void updateLocationEngineName(LocationEngine locationEngine) {
        if (locationEngine != null) {
            String locationEngineName = locationEngine.getClass().getName();
            this.navigationSessionState = this.navigationSessionState.toBuilder().locationEngineName(locationEngineName).build();
        }
    }

    void updateLocation(Location location) {
        this.metricLocation = new MetricsLocation(location);
        this.locationBuffer.addLast(location);
        this.checkRerouteQueue();
        this.checkFeedbackQueue();
    }

    String recordFeedbackEvent(String feedbackType, String description, String feedbackSource) {
        FeedbackEvent feedbackEvent = this.queueFeedbackEvent(feedbackType, description, feedbackSource);
        return feedbackEvent.getEventId();
    }

    void updateFeedbackEvent(String feedbackId, String feedbackType, String description, String screenshot) {
        FeedbackEvent feedbackEvent = (FeedbackEvent)this.findQueuedTelemetryEvent(feedbackId);
        if (feedbackEvent != null) {
            feedbackEvent.setFeedbackType(feedbackType);
            feedbackEvent.setDescription(description);
            feedbackEvent.setScreenshot(screenshot);
        }
    }

    void cancelFeedback(String feedbackId) {
        FeedbackEvent feedbackEvent = (FeedbackEvent)this.findQueuedTelemetryEvent(feedbackId);
        this.queuedFeedbackEvents.remove(feedbackEvent);
    }

    void routeRetrievalEvent(ElapsedTime elapsedTime, String routeUuid) {
        if (this.navigationSessionState != null && !this.navigationSessionState.sessionIdentifier().isEmpty()) {
            double time = elapsedTime.getElapsedTime();
            NavigationMetricsWrapper.routeRetrievalEvent(time, routeUuid, this.navigationSessionState.sessionIdentifier());
        } else {
            this.routeRetrievalElapsedTime = elapsedTime;
            this.routeRetrievalUuid = routeUuid;
        }
    }

    private void validateAccessToken(String accessToken) {
        if (TextUtils.isEmpty((CharSequence)accessToken) || !accessToken.toLowerCase(Locale.US).startsWith("pk.") && !accessToken.toLowerCase(Locale.US).startsWith("sk.")) {
            throw new NavigationException("A valid access token must be passed in when first initializing MapboxNavigation");
        }
    }

    private void initEventDispatcherListeners(MapboxNavigation navigation) {
        this.eventDispatcher = navigation.getEventDispatcher();
        this.eventDispatcher.addMetricEventListeners(this);
    }

    @NonNull
    private String obtainSdkIdentifier(MapboxNavigationOptions options) {
        String sdkIdentifier = MAPBOX_NAVIGATION_SDK_IDENTIFIER;
        if (options.isFromNavigationUi()) {
            sdkIdentifier = MAPBOX_NAVIGATION_UI_SDK_IDENTIFIER;
        }
        return sdkIdentifier;
    }

    private void flushEventQueues() {
        for (FeedbackEvent feedbackEvent : this.queuedFeedbackEvents) {
            this.sendFeedbackEvent(feedbackEvent);
        }
        for (RerouteEvent rerouteEvent : this.queuedRerouteEvents) {
            this.sendRerouteEvent(rerouteEvent);
        }
    }

    private void checkRerouteQueue() {
        ListIterator<RerouteEvent> iterator = this.queuedRerouteEvents.listIterator();
        while (iterator.hasNext()) {
            RerouteEvent rerouteEvent = (RerouteEvent)iterator.next();
            if (!this.shouldSendEvent(rerouteEvent.getSessionState())) continue;
            this.sendRerouteEvent(rerouteEvent);
            iterator.remove();
        }
    }

    private void checkFeedbackQueue() {
        ListIterator<FeedbackEvent> iterator = this.queuedFeedbackEvents.listIterator();
        while (iterator.hasNext()) {
            FeedbackEvent feedbackEvent = (FeedbackEvent)iterator.next();
            if (!this.shouldSendEvent(feedbackEvent.getSessionState())) continue;
            this.sendFeedbackEvent(feedbackEvent);
            iterator.remove();
        }
    }

    private boolean shouldSendEvent(SessionState sessionState) {
        return this.dateDiff(sessionState.eventDate(), new Date(), TimeUnit.SECONDS) > 20L;
    }

    @NonNull
    private List<Location> createLocationListBeforeEvent(Date eventDate) {
        Location[] locations = this.locationBuffer.toArray((Location[])new Location[this.locationBuffer.size()]);
        List<Location> currentLocationList = Arrays.asList(locations);
        ArrayList<Location> locationsBeforeEvent = new ArrayList<Location>();
        for (Location location : currentLocationList) {
            Date locationDate = new Date(location.getTime());
            if (!locationDate.before(eventDate)) continue;
            locationsBeforeEvent.add(location);
        }
        return locationsBeforeEvent;
    }

    @NonNull
    private List<Location> createLocationListAfterEvent(Date eventDate) {
        Location[] locations = this.locationBuffer.toArray((Location[])new Location[this.locationBuffer.size()]);
        List<Location> currentLocationList = Arrays.asList(locations);
        ArrayList<Location> locationsAfterEvent = new ArrayList<Location>();
        for (Location location : currentLocationList) {
            Date locationDate = new Date(location.getTime());
            if (!locationDate.after(eventDate)) continue;
            locationsAfterEvent.add(location);
        }
        return locationsAfterEvent;
    }

    private void updateDistanceCompleted() {
        double currentDistanceCompleted = this.navigationSessionState.eventRouteDistanceCompleted() + (double)this.metricProgress.getDistanceTraveled();
        this.navigationSessionState = this.navigationSessionState.toBuilder().eventRouteDistanceCompleted(currentDistanceCompleted).build();
    }

    private void queueRerouteEvent() {
        this.updateLifecyclePercentages();
        Date eventDate = new Date();
        SessionState rerouteEventSessionState = this.navigationSessionState.toBuilder().eventDate(eventDate).eventRouteProgress(this.metricProgress).eventLocation(this.metricLocation.getLocation()).secondsSinceLastReroute(this.getSecondsSinceLastReroute(eventDate)).mockLocation(this.metricLocation.getLocation().getProvider().equals(MOCK_PROVIDER)).build();
        RerouteEvent rerouteEvent = new RerouteEvent(rerouteEventSessionState);
        this.queuedRerouteEvents.add(rerouteEvent);
    }

    @NonNull
    private FeedbackEvent queueFeedbackEvent(String feedbackType, String description, String feedbackSource) {
        this.updateLifecyclePercentages();
        double distanceCompleted = this.navigationSessionState.eventRouteDistanceCompleted() + (double)this.metricProgress.getDistanceTraveled();
        SessionState feedbackEventSessionState = this.navigationSessionState.toBuilder().eventDate(new Date()).eventRouteProgress(this.metricProgress).eventRouteDistanceCompleted(distanceCompleted).eventLocation(this.metricLocation.getLocation()).mockLocation(this.metricLocation.getLocation().getProvider().equals(MOCK_PROVIDER)).build();
        FeedbackEvent feedbackEvent = new FeedbackEvent(feedbackEventSessionState, feedbackSource);
        feedbackEvent.setDescription(description);
        feedbackEvent.setFeedbackType(feedbackType);
        this.queuedFeedbackEvents.add(feedbackEvent);
        return feedbackEvent;
    }

    private void sendRerouteEvent(RerouteEvent rerouteEvent) {
        if (rerouteEvent.getNewRouteGeometry() == null || rerouteEvent.getSessionState().startTimestamp() == null) {
            return;
        }
        List<Location> beforeLocations = this.createLocationListBeforeEvent(rerouteEvent.getSessionState().eventDate());
        List<Location> afterLocations = this.createLocationListAfterEvent(rerouteEvent.getSessionState().eventDate());
        SessionState rerouteSessionState = rerouteEvent.getSessionState().toBuilder().beforeEventLocations(beforeLocations).afterEventLocations(afterLocations).build();
        rerouteEvent.setRerouteSessionState(rerouteSessionState);
        NavigationMetricsWrapper.rerouteEvent(rerouteEvent, this.metricProgress, rerouteEvent.getSessionState().eventLocation(), this.context);
    }

    private void sendFeedbackEvent(FeedbackEvent feedbackEvent) {
        if (feedbackEvent.getSessionState().startTimestamp() == null) {
            return;
        }
        List<Location> beforeLocations = this.createLocationListBeforeEvent(feedbackEvent.getSessionState().eventDate());
        List<Location> afterLocations = this.createLocationListAfterEvent(feedbackEvent.getSessionState().eventDate());
        SessionState feedbackSessionState = feedbackEvent.getSessionState().toBuilder().beforeEventLocations(beforeLocations).afterEventLocations(afterLocations).build();
        NavigationMetricsWrapper.feedbackEvent(feedbackSessionState, this.metricProgress, feedbackEvent.getSessionState().eventLocation(), feedbackEvent.getDescription(), feedbackEvent.getFeedbackType(), feedbackEvent.getScreenshot(), feedbackEvent.getFeedbackSource(), this.context);
    }

    private long dateDiff(Date firstDate, Date secondDate, TimeUnit timeUnit) {
        long diffInMillis = secondDate.getTime() - firstDate.getTime();
        return timeUnit.convert(diffInMillis, TimeUnit.MILLISECONDS);
    }

    private TelemetryEvent findQueuedTelemetryEvent(String eventId) {
        for (FeedbackEvent feedbackEvent : this.queuedFeedbackEvents) {
            if (!feedbackEvent.getEventId().equals(eventId)) continue;
            return feedbackEvent;
        }
        for (RerouteEvent rerouteEvent : this.queuedRerouteEvents) {
            if (!rerouteEvent.getEventId().equals(eventId)) continue;
            return rerouteEvent;
        }
        return null;
    }

    private void updateLifecyclePercentages() {
        if (this.lifecycleMonitor != null) {
            this.navigationSessionState = this.navigationSessionState.toBuilder().percentInForeground(this.lifecycleMonitor.obtainForegroundPercentage()).percentInPortrait(this.lifecycleMonitor.obtainPortraitPercentage()).build();
        }
    }

    private void updateLastRerouteEvent(DirectionsRoute newDirectionsRoute) {
        if (!this.queuedRerouteEvents.isEmpty()) {
            RerouteEvent rerouteEvent = this.queuedRerouteEvents.get(this.queuedRerouteEvents.size() - 1);
            List geometryPositions = PolylineUtils.decode((String)newDirectionsRoute.geometry(), (int)6);
            PolylineUtils.encode((List)geometryPositions, (int)5);
            rerouteEvent.setNewRouteGeometry(PolylineUtils.encode((List)geometryPositions, (int)5));
            int newDistanceRemaining = newDirectionsRoute.distance() == null ? 0 : newDirectionsRoute.distance().intValue();
            rerouteEvent.setNewDistanceRemaining(newDistanceRemaining);
            int newDurationRemaining = newDirectionsRoute.duration() == null ? 0 : newDirectionsRoute.duration().intValue();
            rerouteEvent.setNewDurationRemaining(newDurationRemaining);
        }
    }

    private int getSecondsSinceLastReroute(Date eventDate) {
        int seconds = -1;
        if (this.lastRerouteDate == null) {
            return seconds;
        }
        long millisSinceLastReroute = eventDate.getTime() - this.lastRerouteDate.getTime();
        return (int)TimeUnit.MILLISECONDS.toSeconds(millisSinceLastReroute);
    }

    private void fireOffBatteryScheduler() {
        Timer batteryTimer = new Timer();
        TimerTask batteryTask = new TimerTask(){

            @Override
            public void run() {
                BatteryEvent batteryEvent = NavigationTelemetry.this.buildBatteryEvent();
                NavigationMetricsWrapper.push(batteryEvent);
            }
        };
        this.batteryChargeReporter = new BatteryChargeReporter(batteryTimer, batteryTask);
        this.batteryChargeReporter.scheduleAt(60000L);
    }

    private BatteryEvent buildBatteryEvent() {
        BatteryMonitor batteryMonitor = new BatteryMonitor();
        float batteryPercentage = batteryMonitor.obtainPercentage(this.context);
        boolean isPluggedIn = batteryMonitor.isPluggedIn(this.context);
        return new BatteryEvent(this.navigationSessionState.sessionIdentifier(), batteryPercentage, isPluggedIn);
    }

    private void cancelBatteryScheduler() {
        if (this.batteryChargeReporter != null) {
            this.batteryChargeReporter.stop();
        }
    }
}

