/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.support.annotation.Nullable;
import android.support.v4.util.Pair;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.api.directions.v5.models.LegStep;
import com.mapbox.api.directions.v5.models.RouteLeg;
import com.mapbox.api.directions.v5.models.StepIntersection;
import com.mapbox.geojson.Point;
import com.mapbox.navigator.BannerInstruction;
import com.mapbox.navigator.NavigationStatus;
import com.mapbox.navigator.RouteState;
import com.mapbox.navigator.VoiceInstruction;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigator;
import com.mapbox.services.android.navigation.v5.navigation.NavigationHelper;
import com.mapbox.services.android.navigation.v5.routeprogress.CurrentLegAnnotation;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgressState;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgressStateMap;
import java.util.List;

class NavigationRouteProcessor {
    private static final int ONE_INDEX = 1;
    private static final double ONE_SECOND_IN_MILLISECONDS = 1000.0;
    private static final int FIRST_BANNER_INSTRUCTION = 0;
    private final RouteProgressStateMap progressStateMap = new RouteProgressStateMap();
    private RouteProgress previousRouteProgress;
    private DirectionsRoute route;
    private RouteLeg currentLeg;
    private LegStep currentStep;
    private List<Point> currentStepPoints;
    private LegStep upcomingStep;
    private List<Point> upcomingStepPoints;
    private List<StepIntersection> currentIntersections;
    private List<Pair<StepIntersection, Double>> currentIntersectionDistances;
    private CurrentLegAnnotation currentLegAnnotation;

    NavigationRouteProcessor() {
    }

    RouteProgress buildNewRouteProgress(MapboxNavigator navigator, NavigationStatus status, DirectionsRoute route) {
        this.updateRoute(route);
        return this.buildRouteProgressFrom(status, navigator);
    }

    void updatePreviousRouteProgress(RouteProgress routeProgress) {
        this.previousRouteProgress = routeProgress;
    }

    @Nullable
    RouteProgress retrievePreviousRouteProgress() {
        return this.previousRouteProgress;
    }

    private void updateRoute(DirectionsRoute route) {
        if (this.route == null || !this.route.equals(route)) {
            this.route = route;
        }
    }

    private RouteProgress buildRouteProgressFrom(NavigationStatus status, MapboxNavigator navigator) {
        int legIndex = status.getLegIndex();
        int stepIndex = status.getStepIndex();
        int upcomingStepIndex = stepIndex + 1;
        this.updateSteps(this.route, legIndex, stepIndex, upcomingStepIndex);
        this.updateStepPoints(this.route, legIndex, stepIndex, upcomingStepIndex);
        this.updateIntersections();
        double legDistanceRemaining = status.getRemainingLegDistance();
        double routeDistanceRemaining = NavigationHelper.routeDistanceRemaining(legDistanceRemaining, legIndex, this.route);
        double stepDistanceRemaining = status.getRemainingStepDistance();
        double stepDistanceTraveled = this.currentStep.distance() - stepDistanceRemaining;
        double legDurationRemaining = (double)status.getRemainingLegDuration() / 1000.0;
        this.currentLegAnnotation = NavigationHelper.createCurrentAnnotation(this.currentLegAnnotation, this.currentLeg, legDistanceRemaining);
        StepIntersection currentIntersection = NavigationHelper.findCurrentIntersection(this.currentIntersections, this.currentIntersectionDistances, stepDistanceTraveled);
        StepIntersection upcomingIntersection = NavigationHelper.findUpcomingIntersection(this.currentIntersections, this.upcomingStep, currentIntersection);
        RouteState routeState = status.getRouteState();
        RouteProgressState currentRouteState = (RouteProgressState)((Object)this.progressStateMap.get(routeState));
        RouteProgress.Builder progressBuilder = RouteProgress.builder().distanceRemaining(routeDistanceRemaining).legDistanceRemaining(legDistanceRemaining).legDurationRemaining(legDurationRemaining).stepDistanceRemaining(stepDistanceRemaining).directionsRoute(this.route).currentStepPoints(this.currentStepPoints).upcomingStepPoints(this.upcomingStepPoints).stepIndex(stepIndex).legIndex(legIndex).intersections(this.currentIntersections).currentIntersection(currentIntersection).upcomingIntersection(upcomingIntersection).intersectionDistancesAlongStep(this.currentIntersectionDistances).currentLegAnnotation(this.currentLegAnnotation).inTunnel(status.getInTunnel()).currentState(currentRouteState);
        this.addVoiceInstructions(status, progressBuilder);
        this.addBannerInstructions(status, navigator, progressBuilder);
        this.addUpcomingStepPoints(progressBuilder);
        return progressBuilder.build();
    }

    private void updateSteps(DirectionsRoute route, int legIndex, int stepIndex, int upcomingStepIndex) {
        List steps;
        List legs = route.legs();
        if (legIndex < legs.size()) {
            this.currentLeg = (RouteLeg)legs.get(legIndex);
        }
        if (stepIndex < (steps = this.currentLeg.steps()).size()) {
            this.currentStep = (LegStep)steps.get(stepIndex);
        }
        this.upcomingStep = upcomingStepIndex < steps.size() - 1 ? (LegStep)steps.get(upcomingStepIndex) : null;
    }

    private void updateStepPoints(DirectionsRoute route, int legIndex, int stepIndex, int upcomingStepIndex) {
        this.currentStepPoints = NavigationHelper.decodeStepPoints(route, this.currentStepPoints, legIndex, stepIndex);
        this.upcomingStepPoints = NavigationHelper.decodeStepPoints(route, null, legIndex, upcomingStepIndex);
    }

    private void updateIntersections() {
        this.currentIntersections = NavigationHelper.createIntersectionsList(this.currentStep, this.upcomingStep);
        this.currentIntersectionDistances = NavigationHelper.createDistancesToIntersections(this.currentStepPoints, this.currentIntersections);
    }

    private void addUpcomingStepPoints(RouteProgress.Builder progressBuilder) {
        if (this.upcomingStepPoints != null && !this.upcomingStepPoints.isEmpty()) {
            progressBuilder.upcomingStepPoints(this.upcomingStepPoints);
        }
    }

    private void addVoiceInstructions(NavigationStatus status, RouteProgress.Builder progressBuilder) {
        VoiceInstruction voiceInstruction = status.getVoiceInstruction();
        progressBuilder.voiceInstruction(voiceInstruction);
    }

    private void addBannerInstructions(NavigationStatus status, MapboxNavigator navigator, RouteProgress.Builder progressBuilder) {
        BannerInstruction bannerInstruction = status.getBannerInstruction();
        if (status.getRouteState() == RouteState.INITIALIZED) {
            bannerInstruction = navigator.retrieveBannerInstruction(0);
        }
        progressBuilder.bannerInstruction(bannerInstruction);
    }
}

