/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.support.annotation.NonNull;
import com.mapbox.api.directions.v5.models.DirectionsResponse;
import com.mapbox.services.android.navigation.v5.navigation.ElapsedTime;
import com.mapbox.services.android.navigation.v5.navigation.NavigationRouteEventListener;
import com.mapbox.services.android.navigation.v5.navigation.NavigationTelemetry;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

class NavigationRouteCallback
implements Callback<DirectionsResponse> {
    private final NavigationTelemetry telemetry;
    private final NavigationRouteEventListener listener;
    private final Callback<DirectionsResponse> callback;

    NavigationRouteCallback(NavigationRouteEventListener listener, Callback<DirectionsResponse> callback) {
        this(NavigationTelemetry.getInstance(), listener, callback);
    }

    NavigationRouteCallback(NavigationTelemetry telemetry, NavigationRouteEventListener listener, Callback<DirectionsResponse> callback) {
        this.telemetry = telemetry;
        this.listener = listener;
        this.callback = callback;
    }

    public void onResponse(@NonNull Call<DirectionsResponse> call, @NonNull Response<DirectionsResponse> response) {
        this.callback.onResponse(call, response);
        if (this.isValid(response)) {
            String uuid = ((DirectionsResponse)response.body()).uuid();
            this.sendEventWith(this.listener.getTime(), uuid);
        }
    }

    public void onFailure(@NonNull Call<DirectionsResponse> call, @NonNull Throwable throwable) {
        this.callback.onFailure(call, throwable);
    }

    private boolean isValid(Response<DirectionsResponse> response) {
        return response.body() != null && !((DirectionsResponse)response.body()).routes().isEmpty();
    }

    private void sendEventWith(ElapsedTime time, String uuid) {
        this.telemetry.routeRetrievalEvent(time, uuid);
    }
}

