/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.location.Location;
import com.mapbox.geojson.Point;
import com.mapbox.navigator.BannerInstruction;
import com.mapbox.navigator.FixLocation;
import com.mapbox.navigator.NavigationStatus;
import com.mapbox.navigator.Navigator;
import com.mapbox.navigator.VoiceInstruction;
import java.util.Date;

class MapboxNavigator {
    private static final int INDEX_FIRST_ROUTE = 0;
    private static final int INDEX_FIRST_LEG = 0;
    private final Navigator navigator;

    MapboxNavigator(Navigator navigator) {
        this.navigator = navigator;
    }

    synchronized void updateRoute(String routeJson) {
        this.navigator.setRoute(routeJson, 0, 0);
    }

    synchronized NavigationStatus retrieveStatus(Date date, long lagInMilliseconds) {
        if (lagInMilliseconds > 0L) {
            date.setTime(date.getTime() + lagInMilliseconds);
        }
        return this.navigator.getStatus(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateLocation(Location raw) {
        FixLocation fixedLocation = this.buildFixLocationFromLocation(raw);
        MapboxNavigator mapboxNavigator = this;
        synchronized (mapboxNavigator) {
            this.navigator.updateLocation(fixedLocation);
        }
    }

    synchronized NavigationStatus updateLegIndex(int index) {
        return this.navigator.changeRouteLeg(0, index);
    }

    synchronized String retrieveHistory() {
        return this.navigator.getHistory();
    }

    synchronized void toggleHistory(boolean isEnabled) {
        this.navigator.toggleHistory(isEnabled);
    }

    synchronized VoiceInstruction retrieveVoiceInstruction(int index) {
        return this.navigator.getVoiceInstruction(index);
    }

    synchronized BannerInstruction retrieveBannerInstruction(int index) {
        return this.navigator.getBannerInstruction(index);
    }

    FixLocation buildFixLocationFromLocation(Location location) {
        Date time = new Date();
        Point rawPoint = Point.fromLngLat((double)location.getLongitude(), (double)location.getLatitude());
        Float speed = this.checkFor(Float.valueOf(location.getSpeed()));
        Float bearing = this.checkFor(Float.valueOf(location.getBearing()));
        Float altitude = this.checkFor(Float.valueOf((float)location.getAltitude()));
        Float horizontalAccuracy = this.checkFor(Float.valueOf(location.getAccuracy()));
        String provider = location.getProvider();
        return new FixLocation(rawPoint, time, speed, bearing, altitude, horizontalAccuracy, provider);
    }

    private Float checkFor(Float value) {
        if ((double)value.floatValue() == 0.0) {
            return null;
        }
        return value;
    }
}

