/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.milestone;

import android.util.SparseArray;
import com.mapbox.services.android.navigation.v5.milestone.Operation;

public class Trigger {
    private Trigger() {
    }

    public static Statement all(Statement ... statements) {
        return new AllStatement(statements);
    }

    public static Statement any(Statement ... statements) {
        return new AnyStatement(statements);
    }

    public static Statement none(Statement ... statements) {
        return new NoneStatement(statements);
    }

    public static Statement eq(int key, Object value) {
        return new EqualStatement(key, value);
    }

    public static Statement neq(int key, Object value) {
        return new NotEqualStatement(key, value);
    }

    public static Statement gt(int key, Object value) {
        return new GreaterThanStatement(key, value);
    }

    public static Statement lt(int key, Object value) {
        return new LessThanStatement(key, value);
    }

    public static Statement lte(int key, Object value) {
        return new LessThanEqualStatement(key, value);
    }

    public static Statement gte(int key, Object value) {
        return new GreaterThanEqualStatement(key, value);
    }

    private static class EqualStatement
    extends Statement {
        private final int key;
        private final Object value;

        EqualStatement(int key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public boolean isOccurring(SparseArray<Number[]> statementObjects) {
            return Operation.equal((Number[])statementObjects.get(this.key), (Number)this.value);
        }
    }

    private static class NotEqualStatement
    extends Statement {
        private final int key;
        private final Object[] values;

        NotEqualStatement(int key, Object ... values) {
            this.key = key;
            this.values = values;
        }

        @Override
        public boolean isOccurring(SparseArray<Number[]> statementObjects) {
            return Operation.notEqual((Number[])statementObjects.get(this.key), (Number)this.values[0]);
        }
    }

    private static class LessThanEqualStatement
    extends Statement {
        private final int key;
        private final Object value;

        LessThanEqualStatement(int key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public boolean isOccurring(SparseArray<Number[]> statementObjects) {
            return Operation.lessThanEqual((Number[])statementObjects.get(this.key), (Number)this.value);
        }
    }

    private static class LessThanStatement
    extends Statement {
        private final int key;
        private final Object value;

        LessThanStatement(int key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public boolean isOccurring(SparseArray<Number[]> statementObjects) {
            return Operation.lessThan((Number[])statementObjects.get(this.key), (Number)this.value);
        }
    }

    private static class GreaterThanEqualStatement
    extends Statement {
        private final int key;
        private final Object value;

        GreaterThanEqualStatement(int key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public boolean isOccurring(SparseArray<Number[]> statementObjects) {
            return Operation.greaterThanEqual((Number[])statementObjects.get(this.key), (Number)this.value);
        }
    }

    private static class GreaterThanStatement
    extends Statement {
        private final int key;
        private final Object value;

        GreaterThanStatement(int key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public boolean isOccurring(SparseArray<Number[]> statementObjects) {
            return Operation.greaterThan((Number[])statementObjects.get(this.key), (Number)this.value);
        }
    }

    private static class AnyStatement
    extends Statement {
        private final Statement[] statements;

        AnyStatement(Statement ... statements) {
            this.statements = statements;
        }

        @Override
        public boolean isOccurring(SparseArray<Number[]> statementObjects) {
            for (Statement statement : this.statements) {
                if (!statement.isOccurring(statementObjects)) continue;
                return true;
            }
            return false;
        }
    }

    private static class NoneStatement
    extends Statement {
        private final Statement[] statements;

        NoneStatement(Statement ... statements) {
            this.statements = statements;
        }

        @Override
        public boolean isOccurring(SparseArray<Number[]> statementObjects) {
            for (Statement statement : this.statements) {
                if (!statement.isOccurring(statementObjects)) continue;
                return false;
            }
            return true;
        }
    }

    private static class AllStatement
    extends Statement {
        private final Statement[] statements;

        AllStatement(Statement ... statements) {
            this.statements = statements;
        }

        @Override
        public boolean isOccurring(SparseArray<Number[]> statementObjects) {
            boolean all = true;
            for (Statement statement : this.statements) {
                if (statement.isOccurring(statementObjects)) continue;
                all = false;
            }
            return all;
        }
    }

    public static abstract class Statement {
        public abstract boolean isOccurring(SparseArray<Number[]> var1);
    }
}

