/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.location.replay;

import android.location.Location;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.api.directions.v5.models.LegStep;
import com.mapbox.api.directions.v5.models.RouteLeg;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.Point;
import com.mapbox.turf.TurfMeasurement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ReplayRouteLocationConverter {
    private static final int ONE_SECOND_IN_MILLISECONDS = 1000;
    private static final double ONE_KM_IN_METERS = 1000.0;
    private static final int ONE_HOUR_IN_SECONDS = 3600;
    private static final String REPLAY_ROUTE = "ReplayRouteLocation";
    private DirectionsRoute route;
    private int speed;
    private int delay;
    private double distance;
    private int currentLeg;
    private int currentStep;
    private long time;

    ReplayRouteLocationConverter(DirectionsRoute route, int speed, int delay) {
        this.initialize();
        this.update(route);
        this.speed = speed;
        this.delay = delay;
        this.distance = this.calculateDistancePerSec();
    }

    void updateSpeed(int customSpeedInKmPerHour) {
        this.speed = customSpeedInKmPerHour;
    }

    void updateDelay(int customDelayInSeconds) {
        this.delay = customDelayInSeconds;
    }

    List<Location> toLocations() {
        List<Point> stepPoints = this.calculateStepPoints();
        List<Location> mockedLocations = this.calculateMockLocations(stepPoints);
        return mockedLocations;
    }

    boolean isMultiLegRoute() {
        return this.route.legs().size() > 1;
    }

    void initializeTime() {
        this.time = System.currentTimeMillis();
    }

    List<Point> sliceRoute(LineString lineString) {
        double distanceMeters = TurfMeasurement.length((LineString)lineString, (String)"meters");
        if (distanceMeters <= 0.0) {
            return Collections.emptyList();
        }
        ArrayList<Point> points = new ArrayList<Point>();
        for (double i = 0.0; i < distanceMeters; i += this.distance) {
            Point point = TurfMeasurement.along((LineString)lineString, (double)i, (String)"meters");
            points.add(point);
        }
        return points;
    }

    List<Location> calculateMockLocations(List<Point> points) {
        ArrayList<Point> pointsToCopy = new ArrayList<Point>(points);
        ArrayList<Location> mockedLocations = new ArrayList<Location>();
        for (Point point : points) {
            Location mockedLocation = this.createMockLocationFrom(point);
            if (pointsToCopy.size() >= 2) {
                double bearing = TurfMeasurement.bearing((Point)point, (Point)((Point)pointsToCopy.get(1)));
                mockedLocation.setBearing((float)bearing);
            }
            this.time += (long)(this.delay * 1000);
            mockedLocations.add(mockedLocation);
            pointsToCopy.remove(point);
        }
        return mockedLocations;
    }

    private void update(DirectionsRoute route) {
        this.route = route;
    }

    private double calculateDistancePerSec() {
        double distance = (double)this.speed * 1000.0 * (double)this.delay / 3600.0;
        return distance;
    }

    private void initialize() {
        this.currentLeg = 0;
        this.currentStep = 0;
    }

    private List<Point> calculateStepPoints() {
        ArrayList<Point> stepPoints = new ArrayList<Point>();
        LineString line = LineString.fromPolyline((String)((LegStep)((RouteLeg)this.route.legs().get(this.currentLeg)).steps().get(this.currentStep)).geometry(), (int)6);
        stepPoints.addAll(this.sliceRoute(line));
        this.increaseIndex();
        return stepPoints;
    }

    private void increaseIndex() {
        if (this.currentStep < ((RouteLeg)this.route.legs().get(this.currentLeg)).steps().size() - 1) {
            ++this.currentStep;
        } else if (this.currentLeg < this.route.legs().size() - 1) {
            ++this.currentLeg;
            this.currentStep = 0;
        }
    }

    private Location createMockLocationFrom(Point point) {
        Location mockedLocation = new Location(REPLAY_ROUTE);
        mockedLocation.setLatitude(point.latitude());
        mockedLocation.setLongitude(point.longitude());
        float speedInMetersPerSec = (float)((double)this.speed * 1000.0 / 3600.0);
        mockedLocation.setSpeed(speedInMetersPerSec);
        mockedLocation.setAccuracy(3.0f);
        mockedLocation.setTime(this.time);
        return mockedLocation;
    }
}

