/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.voice;

import android.content.Context;
import com.mapbox.api.speech.v1.MapboxSpeech;
import com.mapbox.services.android.navigation.ui.v5.ConnectivityStatusProvider;
import com.mapbox.services.android.navigation.ui.v5.voice.InstructionCacheCallback;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.Cache;
import okhttp3.CacheControl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import retrofit2.Callback;
import timber.log.Timber;

public class VoiceInstructionLoader {
    private static final int VOICE_INSTRUCTIONS_TO_EVICT_THRESHOLD = 4;
    private static final String SSML_TEXT_TYPE = "ssml";
    private final ConnectivityStatusProvider connectivityStatus;
    private final String accessToken;
    private List<String> urlsCached;
    private final Cache cache;
    private MapboxSpeech.Builder mapboxSpeechBuilder = null;

    public VoiceInstructionLoader(Context context, String accessToken, Cache cache) {
        this.connectivityStatus = new ConnectivityStatusProvider(context);
        this.accessToken = accessToken;
        this.urlsCached = new ArrayList<String>();
        this.cache = cache;
    }

    VoiceInstructionLoader(String accessToken, Cache cache, MapboxSpeech.Builder mapboxSpeechBuilder, ConnectivityStatusProvider connectivityStatus) {
        this.accessToken = accessToken;
        this.urlsCached = new ArrayList<String>();
        this.cache = cache;
        this.mapboxSpeechBuilder = mapboxSpeechBuilder;
        this.connectivityStatus = connectivityStatus;
    }

    public List<String> evictVoiceInstructions() {
        ArrayList<String> urlsToRemove = new ArrayList<String>();
        block2: for (int i = 0; i < this.urlsCached.size() && i < 4; ++i) {
            String urlToRemove = this.urlsCached.get(i);
            try {
                Iterator urlsCurrentlyCached;
                Iterator urlCached = urlsCurrentlyCached = this.cache.urls();
                while (urlCached.hasNext()) {
                    String url = (String)urlCached.next();
                    if (!url.equals(urlToRemove)) continue;
                    urlCached.remove();
                    urlsToRemove.add(urlToRemove);
                    continue block2;
                }
                continue;
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
        this.urlsCached.removeAll(urlsToRemove);
        return urlsToRemove;
    }

    public void cacheInstructions(List<String> instructions) {
        for (String instruction : instructions) {
            this.cacheInstruction(instruction);
        }
    }

    void addStubUrlsToCache(List<String> urlsToCache) {
        this.urlsCached = urlsToCache;
    }

    void setupMapboxSpeechBuilder(String language) {
        if (this.mapboxSpeechBuilder == null) {
            this.mapboxSpeechBuilder = MapboxSpeech.builder().accessToken(this.accessToken).language(language).cache(this.cache).interceptor(this.provideOfflineCacheInterceptor());
        }
    }

    void requestInstruction(String instruction, String textType, Callback<ResponseBody> callback) {
        if (!this.cache.isClosed() && this.mapboxSpeechBuilder != null) {
            MapboxSpeech mapboxSpeech = this.mapboxSpeechBuilder.instruction(instruction).textType(textType).build();
            mapboxSpeech.enqueueCall(callback);
        }
    }

    boolean hasCache() {
        return !this.urlsCached.isEmpty();
    }

    void flushCache() {
        try {
            this.cache.evictAll();
        }
        catch (IOException exception) {
            Timber.e((Throwable)exception);
        }
    }

    void addCachedUrl(String url) {
        this.urlsCached.add(url);
    }

    private void cacheInstruction(String instruction) {
        this.requestInstruction(instruction, SSML_TEXT_TYPE, new InstructionCacheCallback(this));
    }

    private Interceptor provideOfflineCacheInterceptor() {
        return new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                if (!VoiceInstructionLoader.this.connectivityStatus.isConnected()) {
                    CacheControl cacheControl = new CacheControl.Builder().maxStale(3, TimeUnit.DAYS).build();
                    request = request.newBuilder().cacheControl(cacheControl).build();
                }
                return chain.proceed(request);
            }
        };
    }
}

