/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.summary.list;

import android.support.annotation.NonNull;
import android.text.SpannableString;
import com.mapbox.api.directions.v5.models.BannerInstructions;
import com.mapbox.api.directions.v5.models.LegStep;
import com.mapbox.api.directions.v5.models.RouteLeg;
import com.mapbox.services.android.navigation.ui.v5.summary.list.InstructionListView;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteLegProgress;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import com.mapbox.services.android.navigation.v5.utils.DistanceFormatter;
import com.mapbox.services.android.navigation.v5.utils.RouteUtils;
import java.util.ArrayList;
import java.util.List;

class InstructionListPresenter {
    private static final int TWO_LINES = 2;
    private static final int ONE_LINE = 1;
    private static final float TWO_LINE_BIAS = 0.65f;
    private static final float ONE_LINE_BIAS = 0.5f;
    private static final int FIRST_INSTRUCTION_INDEX = 0;
    private final RouteUtils routeUtils;
    private DistanceFormatter distanceFormatter;
    private List<BannerInstructions> instructions;
    private RouteLeg currentLeg;
    private String drivingSide;

    InstructionListPresenter(RouteUtils routeUtils, DistanceFormatter distanceFormatter) {
        this.routeUtils = routeUtils;
        this.distanceFormatter = distanceFormatter;
        this.instructions = new ArrayList<BannerInstructions>();
    }

    void onBindInstructionListViewAtPosition(int position, @NonNull InstructionListView listView) {
        BannerInstructions bannerInstructions = this.instructions.get(position);
        double distance = bannerInstructions.distanceAlongGeometry();
        SpannableString distanceText = this.distanceFormatter.formatDistance(distance);
        this.updateListView(listView, bannerInstructions, distanceText);
    }

    int retrieveBannerInstructionListSize() {
        return this.instructions.size();
    }

    boolean updateBannerListWith(RouteProgress routeProgress) {
        this.addBannerInstructions(routeProgress);
        return this.updateInstructionList(routeProgress);
    }

    void updateDistanceFormatter(DistanceFormatter distanceFormatter) {
        if (this.shouldUpdate(distanceFormatter)) {
            this.distanceFormatter = distanceFormatter;
        }
    }

    private boolean shouldUpdate(DistanceFormatter distanceFormatter) {
        return distanceFormatter != null && (this.distanceFormatter == null || !this.distanceFormatter.equals(distanceFormatter));
    }

    private void updateListView(@NonNull InstructionListView listView, BannerInstructions bannerInstructions, SpannableString distanceText) {
        listView.updatePrimaryText(bannerInstructions.primary().text());
        this.updateSecondaryInstruction(listView, bannerInstructions);
        this.updateManeuverView(listView, bannerInstructions);
        listView.updateDistanceText(distanceText);
    }

    private void updateSecondaryInstruction(@NonNull InstructionListView listView, BannerInstructions bannerInstructions) {
        boolean hasSecondaryInstructions = bannerInstructions.secondary() != null;
        this.adjustListViewForSecondaryInstructions(listView, hasSecondaryInstructions);
        if (hasSecondaryInstructions) {
            listView.updateSecondaryText(bannerInstructions.secondary().text());
        }
    }

    private void adjustListViewForSecondaryInstructions(InstructionListView listView, boolean hasSecondaryInstructions) {
        if (hasSecondaryInstructions) {
            this.hasSecondaryInstructions(listView);
        } else {
            this.hasNoSecondaryInstructions(listView);
        }
    }

    private void hasSecondaryInstructions(InstructionListView listView) {
        listView.updatePrimaryMaxLines(1);
        listView.updateSecondaryVisibility(0);
        listView.updateBannerVerticalBias(0.65f);
    }

    private void hasNoSecondaryInstructions(InstructionListView listView) {
        listView.updatePrimaryMaxLines(2);
        listView.updateSecondaryVisibility(8);
        listView.updateBannerVerticalBias(0.5f);
    }

    private void updateManeuverView(@NonNull InstructionListView listView, BannerInstructions bannerInstructions) {
        String maneuverType = bannerInstructions.primary().type();
        String maneuverModifier = bannerInstructions.primary().modifier();
        listView.updateManeuverViewTypeAndModifier(maneuverType, maneuverModifier);
        Double roundaboutDegrees = bannerInstructions.primary().degrees();
        if (roundaboutDegrees != null) {
            listView.updateManeuverViewRoundaboutDegrees(roundaboutDegrees.floatValue());
        }
        listView.updateManeuverViewDrivingSide(this.drivingSide);
    }

    private void addBannerInstructions(RouteProgress routeProgress) {
        if (this.isNewLeg(routeProgress)) {
            this.instructions = new ArrayList<BannerInstructions>();
            this.currentLeg = routeProgress.currentLeg();
            this.drivingSide = routeProgress.currentLegProgress().currentStep().drivingSide();
            List steps = this.currentLeg.steps();
            for (LegStep step : steps) {
                List bannerInstructions = step.bannerInstructions();
                if (bannerInstructions == null || bannerInstructions.isEmpty()) continue;
                this.instructions.addAll(bannerInstructions);
            }
        }
    }

    private boolean isNewLeg(RouteProgress routeProgress) {
        return this.currentLeg == null || !this.currentLeg.equals(routeProgress.currentLeg());
    }

    private boolean updateInstructionList(RouteProgress routeProgress) {
        double stepDistanceRemaining;
        if (this.instructions.isEmpty()) {
            return false;
        }
        RouteLegProgress legProgress = routeProgress.currentLegProgress();
        LegStep currentStep = legProgress.currentStep();
        BannerInstructions currentBannerInstructions = this.routeUtils.findCurrentBannerInstructions(currentStep, stepDistanceRemaining = legProgress.currentStepProgress().distanceRemaining());
        if (!this.instructions.contains(currentBannerInstructions)) {
            return false;
        }
        int currentInstructionIndex = this.instructions.indexOf(currentBannerInstructions);
        return this.removeInstructionsFrom(currentInstructionIndex);
    }

    private boolean removeInstructionsFrom(int currentInstructionIndex) {
        if (currentInstructionIndex == 0) {
            this.instructions.remove(0);
            return true;
        }
        if (currentInstructionIndex <= this.instructions.size()) {
            this.instructions.subList(0, currentInstructionIndex).clear();
            return true;
        }
        return false;
    }
}

