/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.route;

import android.os.AsyncTask;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.services.android.navigation.ui.v5.route.OnPrimaryRouteUpdatedCallback;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

class PrimaryRouteUpdateTask
extends AsyncTask<Void, Void, List<FeatureCollection>> {
    private final int newPrimaryIndex;
    private final List<FeatureCollection> routeFeatureCollections;
    private final WeakReference<OnPrimaryRouteUpdatedCallback> callbackWeakReference;

    PrimaryRouteUpdateTask(int newPrimaryIndex, List<FeatureCollection> routeFeatureCollections, OnPrimaryRouteUpdatedCallback callback) {
        this.newPrimaryIndex = newPrimaryIndex;
        this.routeFeatureCollections = routeFeatureCollections;
        this.callbackWeakReference = new WeakReference<OnPrimaryRouteUpdatedCallback>(callback);
    }

    protected List<FeatureCollection> doInBackground(Void ... voids) {
        ArrayList<FeatureCollection> updatedRouteCollections = new ArrayList<FeatureCollection>(this.routeFeatureCollections);
        if (updatedRouteCollections.isEmpty()) {
            return this.routeFeatureCollections;
        }
        FeatureCollection primaryCollection = (FeatureCollection)updatedRouteCollections.remove(this.newPrimaryIndex);
        List primaryFeatures = primaryCollection.features();
        if (primaryFeatures == null || primaryFeatures.isEmpty()) {
            return this.routeFeatureCollections;
        }
        for (Feature feature : primaryFeatures) {
            feature.addBooleanProperty("primary-route", Boolean.valueOf(true));
        }
        for (FeatureCollection nonPrimaryCollection : updatedRouteCollections) {
            List nonPrimaryFeatures = nonPrimaryCollection.features();
            if (nonPrimaryFeatures == null || nonPrimaryFeatures.isEmpty()) continue;
            for (Feature feature : nonPrimaryFeatures) {
                feature.addBooleanProperty("primary-route", Boolean.valueOf(false));
            }
        }
        updatedRouteCollections.add(0, primaryCollection);
        return updatedRouteCollections;
    }

    protected void onPostExecute(List<FeatureCollection> updatedRouteCollections) {
        Runtime.getRuntime().gc();
        OnPrimaryRouteUpdatedCallback callback = (OnPrimaryRouteUpdatedCallback)this.callbackWeakReference.get();
        if (callback != null) {
            callback.onPrimaryRouteUpdated(updatedRouteCollections);
        }
    }
}

