/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.map;

import android.support.annotation.NonNull;
import com.mapbox.mapboxsdk.location.LocationComponent;
import com.mapbox.mapboxsdk.maps.MapboxMap;

class LocationFpsDelegate
implements MapboxMap.OnCameraIdleListener {
    private static final int ZOOM_LEVEL_FIVE = 5;
    private static final int ZOOM_LEVEL_TEN = 10;
    private static final int ZOOM_LEVEL_FOURTEEN = 14;
    private static final int ZOOM_LEVEL_SIXTEEN = 16;
    private static final int ZOOM_LEVEL_EIGHTEEN = 18;
    private static final int MAX_ANIMATION_FPS_THREE = 3;
    private static final int MAX_ANIMATION_FPS_FIVE = 5;
    private static final int MAX_ANIMATION_FPS_TEN = 10;
    private static final int MAX_ANIMATION_FPS_FIFTEEN = 15;
    private static final int MAX_ANIMATION_FPS_TWENTY_FIVE = 25;
    private static final int MAX_ANIMATION_FPS = Integer.MAX_VALUE;
    private final MapboxMap mapboxMap;
    private final LocationComponent locationComponent;
    private int currentFps = Integer.MAX_VALUE;
    private boolean isEnabled = true;

    LocationFpsDelegate(@NonNull MapboxMap mapboxMap, @NonNull LocationComponent locationComponent) {
        this.mapboxMap = mapboxMap;
        this.locationComponent = locationComponent;
        mapboxMap.addOnCameraIdleListener((MapboxMap.OnCameraIdleListener)this);
    }

    public void onCameraIdle() {
        if (!this.isEnabled) {
            return;
        }
        this.updateMaxFps();
    }

    void onStart() {
        this.mapboxMap.addOnCameraIdleListener((MapboxMap.OnCameraIdleListener)this);
    }

    void onStop() {
        this.mapboxMap.removeOnCameraIdleListener((MapboxMap.OnCameraIdleListener)this);
    }

    void updateEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        this.resetMaxFps();
    }

    boolean isEnabled() {
        return this.isEnabled;
    }

    private void updateMaxFps() {
        double zoom = this.mapboxMap.getCameraPosition().zoom;
        int maxAnimationFps = this.buildFpsFrom(zoom);
        if (this.currentFps != maxAnimationFps) {
            this.locationComponent.setMaxAnimationFps(maxAnimationFps);
            this.currentFps = maxAnimationFps;
        }
    }

    private int buildFpsFrom(double zoom) {
        int maxAnimationFps = zoom < 5.0 ? 3 : (zoom < 10.0 ? 5 : (zoom < 14.0 ? 10 : (zoom < 16.0 ? 15 : (zoom < 18.0 ? 25 : Integer.MAX_VALUE))));
        return maxAnimationFps;
    }

    private void resetMaxFps() {
        if (!this.isEnabled) {
            this.locationComponent.setMaxAnimationFps(Integer.MAX_VALUE);
        }
    }
}

