/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.instruction.maneuver;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.PointF;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v4.util.Pair;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.mapbox.services.android.navigation.ui.v5.R;
import com.mapbox.services.android.navigation.ui.v5.instruction.maneuver.ManeuverViewMap;
import com.mapbox.services.android.navigation.ui.v5.instruction.maneuver.ManeuverViewUpdate;
import com.mapbox.services.android.navigation.ui.v5.instruction.maneuver.ManeuversStyleKit;
import com.mapbox.services.android.navigation.v5.navigation.NavigationConstants;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ManeuverView
extends View {
    private static final float TOP_ROUNDABOUT_ANGLE_LIMIT = 300.0f;
    private static final float BOTTOM_ROUNDABOUT_ANGLE_LIMIT = 60.0f;
    private static final float DEFAULT_ROUNDABOUT_ANGLE = 180.0f;
    private static final Map<Pair<String, String>, ManeuverViewUpdate> MANEUVER_VIEW_UPDATE_MAP = new ManeuverViewMap();
    private static final Set<String> SHOULD_FLIP_MODIFIERS = new HashSet<String>(){
        {
            this.add("slight left");
            this.add("left");
            this.add("sharp left");
            this.add("uturn");
        }
    };
    private static final Set<String> ROUNDABOUT_MANEUVER_TYPES = new HashSet<String>(){
        {
            this.add("rotary");
            this.add("roundabout");
            this.add("roundabout turn");
            this.add("exit roundabout");
            this.add("exit rotary");
        }
    };
    private static final Set<String> MANEUVER_TYPES_WITH_NULL_MODIFIERS = new HashSet<String>(){
        {
            this.add("off ramp");
            this.add("fork");
            this.add("roundabout");
            this.add("roundabout turn");
            this.add("exit roundabout");
            this.add("rotary");
            this.add("exit rotary");
        }
    };
    @NavigationConstants.ManeuverType
    private String maneuverType = null;
    @NavigationConstants.ManeuverModifier
    private String maneuverModifier = null;
    @ColorInt
    private int primaryColor;
    @ColorInt
    private int secondaryColor;
    private float roundaboutAngle = 180.0f;
    private Pair<String, String> maneuverTypeAndModifier = new Pair(null, null);
    private PointF size;
    private String drivingSide = "right";

    public ManeuverView(Context context) {
        super(context);
    }

    public ManeuverView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initializeColorFrom(attrs);
    }

    public ManeuverView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initializeColorFrom(attrs);
    }

    public void setManeuverTypeAndModifier(@NonNull String maneuverType, @Nullable String maneuverModifier) {
        if (this.isNewTypeOrModifier(maneuverType, maneuverModifier)) {
            this.maneuverType = maneuverType;
            this.maneuverModifier = maneuverModifier;
            if (this.checkManeuverTypeWithNullModifier(maneuverType)) {
                return;
            }
            maneuverType = this.checkManeuverModifier(maneuverType, maneuverModifier);
            this.maneuverTypeAndModifier = new Pair((Object)maneuverType, (Object)maneuverModifier);
            this.invalidate();
        }
    }

    public void setRoundaboutAngle(@FloatRange(from=60.0, to=300.0) float roundaboutAngle) {
        if (ROUNDABOUT_MANEUVER_TYPES.contains(this.maneuverType) && this.roundaboutAngle != roundaboutAngle) {
            this.updateRoundaboutAngle(roundaboutAngle);
            this.invalidate();
        }
    }

    public void setDrivingSide(String drivingSide) {
        if ("left".equals(drivingSide) || "right".equals(drivingSide)) {
            this.updateDrivingSide(drivingSide);
            this.invalidate();
        }
    }

    public void setPrimaryColor(@ColorInt int primaryColor) {
        this.primaryColor = primaryColor;
        this.invalidate();
    }

    public void setSecondaryColor(@ColorInt int secondaryColor) {
        this.secondaryColor = secondaryColor;
        this.invalidate();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.setLayerType(1, null);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.size == null) {
            this.size = new PointF((float)this.getMeasuredWidth(), (float)this.getMeasuredHeight());
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isInEditMode()) {
            ManeuversStyleKit.drawArrowStraight(canvas, this.primaryColor, this.size);
            return;
        }
        if (this.maneuverType == null) {
            return;
        }
        ManeuverViewUpdate maneuverViewUpdate = MANEUVER_VIEW_UPDATE_MAP.get(this.maneuverTypeAndModifier);
        if (maneuverViewUpdate != null) {
            maneuverViewUpdate.updateManeuverView(canvas, this.primaryColor, this.secondaryColor, this.size, this.roundaboutAngle);
        }
        if (this.drivingSide.equals("right")) {
            boolean flip = SHOULD_FLIP_MODIFIERS.contains(this.maneuverModifier);
            this.setScaleX(flip ? -1.0f : 1.0f);
        }
    }

    private void initializeColorFrom(AttributeSet attributeSet) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.ManeuverView);
        this.primaryColor = typedArray.getColor(R.styleable.ManeuverView_maneuverViewPrimaryColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.mapbox_navigation_view_color_banner_maneuver_primary));
        this.secondaryColor = typedArray.getColor(R.styleable.ManeuverView_maneuverViewSecondaryColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.mapbox_navigation_view_color_banner_maneuver_secondary));
        typedArray.recycle();
    }

    private boolean isNewTypeOrModifier(String maneuverType, String maneuverModifier) {
        if (maneuverType == null) {
            return false;
        }
        return !TextUtils.equals((CharSequence)this.maneuverType, (CharSequence)maneuverType) || !TextUtils.equals((CharSequence)this.maneuverModifier, (CharSequence)maneuverModifier);
    }

    private boolean checkManeuverTypeWithNullModifier(String maneuverType) {
        if (MANEUVER_TYPES_WITH_NULL_MODIFIERS.contains(maneuverType)) {
            this.maneuverTypeAndModifier = new Pair((Object)maneuverType, null);
            this.invalidate();
            return true;
        }
        return false;
    }

    @Nullable
    private String checkManeuverModifier(String maneuverType, String maneuverModifier) {
        if (!maneuverType.contentEquals("arrive") && maneuverModifier != null) {
            maneuverType = null;
        }
        return maneuverType;
    }

    private void updateRoundaboutAngle(float roundaboutAngle) {
        if (this.checkRoundaboutBottomLimit(roundaboutAngle)) {
            return;
        }
        if (this.checkRoundaboutTopLimit(roundaboutAngle)) {
            return;
        }
        this.roundaboutAngle = roundaboutAngle;
    }

    private void updateDrivingSide(String drivingSide) {
        this.drivingSide = drivingSide;
    }

    private boolean checkRoundaboutBottomLimit(float roundaboutAngle) {
        if (roundaboutAngle < 60.0f) {
            this.roundaboutAngle = 60.0f;
            return true;
        }
        return false;
    }

    private boolean checkRoundaboutTopLimit(float roundaboutAngle) {
        if (roundaboutAngle > 300.0f) {
            this.roundaboutAngle = 300.0f;
            return true;
        }
        return false;
    }
}

