/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.instruction;

import android.util.SparseArray;
import com.mapbox.services.android.navigation.v5.navigation.SdkVersionChecker;

class UrlDensityMap
extends SparseArray<String> {
    private static final String ONE_X = "@1x";
    private static final String TWO_X = "@2x";
    private static final String THREE_X = "@3x";
    private static final String FOUR_X = "@4x";
    private static final String DOT_PNG = ".png";
    private final int displayDensity;

    UrlDensityMap(int displayDensity, SdkVersionChecker sdkVersionChecker) {
        super(4);
        this.displayDensity = displayDensity;
        this.put(120, "@1x.png");
        this.put(160, "@1x.png");
        this.put(240, "@2x.png");
        this.put(320, "@3x.png");
        if (sdkVersionChecker.isEqualOrGreaterThan(16)) {
            this.put(480, "@3x.png");
        }
        if (sdkVersionChecker.isEqualOrGreaterThan(18)) {
            this.put(640, "@4x.png");
        }
        if (sdkVersionChecker.isEqualOrGreaterThan(19)) {
            this.put(400, "@3x.png");
        }
        if (sdkVersionChecker.isEqualOrGreaterThan(21)) {
            this.put(560, "@4x.png");
        }
        if (sdkVersionChecker.isEqualOrGreaterThan(22)) {
            this.put(280, "@2x.png");
        }
        if (sdkVersionChecker.isEqualOrGreaterThan(23)) {
            this.put(360, "@3x.png");
            this.put(420, "@3x.png");
        }
        if (sdkVersionChecker.isEqualOrGreaterThan(25)) {
            this.put(260, "@2x.png");
            this.put(300, "@2x.png");
            this.put(340, "@3x.png");
        }
        if (sdkVersionChecker.isEqualOrGreaterThan(28)) {
            this.put(440, "@3x.png");
        }
    }

    public String get(String url) {
        return url + (String)super.get(this.displayDensity);
    }
}

