/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.instruction;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.text.Spannable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.ImageSpan;
import android.widget.TextView;
import com.mapbox.services.android.navigation.ui.v5.instruction.BannerShield;
import com.mapbox.services.android.navigation.ui.v5.instruction.TextViewUtils;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Target;
import java.util.List;
import timber.log.Timber;

public class InstructionTarget
implements Target {
    private TextView textView;
    private Spannable instructionSpannable;
    private List<BannerShield> shields;
    private BannerShield shield;
    private InstructionLoadedCallback instructionLoadedCallback;
    private TextViewUtils textViewUtils;

    InstructionTarget(TextView textView, Spannable instructionSpannable, List<BannerShield> shields, BannerShield shield, InstructionLoadedCallback instructionLoadedCallback) {
        this(textView, instructionSpannable, shields, shield, new TextViewUtils(), instructionLoadedCallback);
    }

    private InstructionTarget(TextView textView, Spannable instructionSpannable, List<BannerShield> shields, BannerShield shield, TextViewUtils textViewUtils, InstructionLoadedCallback instructionLoadedCallback) {
        this.textView = textView;
        this.instructionSpannable = instructionSpannable;
        this.shields = shields;
        this.shield = shield;
        this.instructionLoadedCallback = instructionLoadedCallback;
        this.textViewUtils = textViewUtils;
    }

    BannerShield getShield() {
        return this.shield;
    }

    public void onBitmapLoaded(Bitmap bitmap, Picasso.LoadedFrom from) {
        Drawable drawable2 = this.textViewUtils.createDrawable(this.textView, bitmap);
        this.createAndSetImageSpan(drawable2);
        this.sendInstructionLoadedCallback();
    }

    public void onBitmapFailed(Exception exception, Drawable errorDrawable) {
        this.setBackupText();
        this.sendInstructionLoadedCallback();
        Timber.e((Throwable)exception);
    }

    public void onPrepareLoad(Drawable placeHolderDrawable) {
    }

    private void setBackupText() {
        this.textView.setText((CharSequence)this.shield.getText());
    }

    private void createAndSetImageSpan(Drawable drawable2) {
        this.instructionSpannable.setSpan((Object)new ImageSpan(drawable2), this.shield.getStartIndex(), this.shield.getEndIndex(), 33);
        if (this.shields.indexOf(this.shield) == this.shields.size() - 1) {
            CharSequence truncatedSequence = InstructionTarget.truncateImageSpan(this.instructionSpannable, this.textView);
            this.textView.setText(truncatedSequence);
        }
    }

    private void sendInstructionLoadedCallback() {
        if (this.instructionLoadedCallback != null) {
            this.instructionLoadedCallback.onInstructionLoaded(this);
        }
    }

    private static CharSequence truncateImageSpan(Spannable instructionSpannable, TextView textView) {
        int availableSpace = textView.getWidth() - textView.getPaddingRight() - textView.getPaddingLeft();
        if (availableSpace > 0) {
            return TextUtils.ellipsize((CharSequence)instructionSpannable, (TextPaint)textView.getPaint(), (float)availableSpace, (TextUtils.TruncateAt)TextUtils.TruncateAt.END);
        }
        return instructionSpannable;
    }

    static interface InstructionLoadedCallback {
        public void onInstructionLoaded(InstructionTarget var1);
    }
}

