/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.instruction;

import android.content.Context;
import android.os.Build;
import android.text.Spannable;
import android.text.SpannableString;
import android.widget.TextView;
import com.mapbox.api.directions.v5.models.BannerComponents;
import com.mapbox.api.directions.v5.models.BannerInstructions;
import com.mapbox.api.directions.v5.models.BannerText;
import com.mapbox.api.directions.v5.models.LegStep;
import com.mapbox.services.android.navigation.ui.v5.instruction.BannerComponentNode;
import com.mapbox.services.android.navigation.ui.v5.instruction.BannerShield;
import com.mapbox.services.android.navigation.ui.v5.instruction.ImageVerifier;
import com.mapbox.services.android.navigation.ui.v5.instruction.InstructionTarget;
import com.mapbox.services.android.navigation.ui.v5.instruction.NodeCreator;
import com.mapbox.services.android.navigation.ui.v5.instruction.UrlDensityMap;
import com.mapbox.services.android.navigation.v5.navigation.SdkVersionChecker;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Target;
import java.util.ArrayList;
import java.util.List;

public class ImageCreator
extends NodeCreator<BannerComponentNode, ImageVerifier> {
    private static ImageCreator instance;
    private boolean isInitialized;
    private Picasso picassoImageLoader;
    private List<InstructionTarget> targets;
    private UrlDensityMap urlDensityMap;
    private List<BannerShield> bannerShieldList;

    private ImageCreator(ImageVerifier imageVerifier) {
        super(imageVerifier);
    }

    @Override
    BannerComponentNode setupNode(BannerComponents components, int index, int startIndex, String modifier) {
        this.addShieldInfo(components, index);
        return new BannerComponentNode(components, startIndex);
    }

    private void addShieldInfo(BannerComponents bannerComponents, int index) {
        this.bannerShieldList.add(new BannerShield(bannerComponents, index));
    }

    public static synchronized ImageCreator getInstance() {
        if (instance == null) {
            instance = new ImageCreator(new ImageVerifier());
        }
        return instance;
    }

    public void initialize(Context context) {
        if (!this.isInitialized) {
            this.initializePicasso(context);
            this.initializeData(context);
            this.isInitialized = true;
        }
    }

    public void prefetchImageCache(LegStep legStep) {
        this.checkIsInitialized();
        this.fetchInstructions(legStep);
    }

    public void shutdown() {
        this.targets.clear();
    }

    private void loadImages(TextView textView, List<BannerComponentNode> bannerComponentNodes) {
        if (!this.hasImages()) {
            return;
        }
        this.updateShieldUrlIndices(bannerComponentNodes);
        this.createTargets(textView);
        this.loadTargets();
    }

    private void initializePicasso(Context context) {
        Picasso.Builder builder = new Picasso.Builder(context);
        this.picassoImageLoader = builder.build();
    }

    private void initializeData(Context context) {
        SdkVersionChecker currentVersionChecker = new SdkVersionChecker(Build.VERSION.SDK_INT);
        int displayDensity = context.getResources().getDisplayMetrics().densityDpi;
        this.urlDensityMap = new UrlDensityMap(displayDensity, currentVersionChecker);
        this.targets = new ArrayList<InstructionTarget>();
        this.bannerShieldList = new ArrayList<BannerShield>();
    }

    private void fetchInstructions(LegStep legStep) {
        if (legStep == null || legStep.bannerInstructions() == null || legStep.bannerInstructions().isEmpty()) {
            return;
        }
        ArrayList bannerInstructionList = new ArrayList(legStep.bannerInstructions());
        for (BannerInstructions instructions : bannerInstructionList) {
            if (this.hasComponents(instructions.primary())) {
                this.fetchImageBaseUrls(instructions.primary());
            }
            if (!this.hasComponents(instructions.secondary())) continue;
            this.fetchImageBaseUrls(instructions.secondary());
        }
    }

    private void updateShieldUrlIndices(List<BannerComponentNode> bannerComponentNodes) {
        for (BannerShield bannerShield : this.bannerShieldList) {
            bannerShield.setStartIndex(bannerComponentNodes.get((int)bannerShield.getNodeIndex()).startIndex);
        }
    }

    private boolean hasComponents(BannerText bannerText) {
        return bannerText != null && bannerText.components() != null && !bannerText.components().isEmpty();
    }

    private boolean hasImages() {
        return !this.bannerShieldList.isEmpty();
    }

    private void fetchImageBaseUrls(BannerText bannerText) {
        for (BannerComponents components : bannerText.components()) {
            if (!((ImageVerifier)this.nodeVerifier).hasImageUrl(components)) continue;
            this.picassoImageLoader.load(this.urlDensityMap.get(components.imageBaseUrl())).fetch();
        }
    }

    private void createTargets(TextView textView) {
        SpannableString instructionSpannable = new SpannableString(textView.getText());
        for (BannerShield bannerShield : this.bannerShieldList) {
            this.targets.add(new InstructionTarget(textView, (Spannable)instructionSpannable, this.bannerShieldList, bannerShield, new InstructionTarget.InstructionLoadedCallback(){

                @Override
                public void onInstructionLoaded(InstructionTarget target) {
                    ImageCreator.this.targets.remove(target);
                }
            }));
        }
        this.bannerShieldList.clear();
    }

    private void loadTargets() {
        for (InstructionTarget target : new ArrayList<InstructionTarget>(this.targets)) {
            this.picassoImageLoader.load(this.urlDensityMap.get(target.getShield().getUrl())).into((Target)target);
        }
    }

    private void checkIsInitialized() {
        if (!this.isInitialized) {
            throw new RuntimeException("ImageCreator must be initialized prior to loading image URLs");
        }
    }

    @Override
    void postProcess(TextView textView, List<BannerComponentNode> bannerComponentNodes) {
        this.loadImages(textView, bannerComponentNodes);
    }
}

