/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.instruction;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.mapbox.api.directions.v5.models.BannerComponents;
import com.mapbox.services.android.navigation.ui.v5.R;
import com.mapbox.services.android.navigation.ui.v5.instruction.BannerComponentNode;
import com.mapbox.services.android.navigation.ui.v5.instruction.ExitSignVerifier;
import com.mapbox.services.android.navigation.ui.v5.instruction.NodeCreator;
import com.mapbox.services.android.navigation.ui.v5.instruction.TextViewUtils;
import java.util.List;

class ExitSignCreator
extends NodeCreator<BannerComponentNode, ExitSignVerifier> {
    private String exitNumber;
    private int startIndex;
    private TextViewUtils textViewUtils = new TextViewUtils();
    private String modifier;
    private static final String EXIT = "exit";
    private static final String EXIT_NUMBER = "exit-number";
    private static final String LEFT = "left";

    ExitSignCreator() {
        super(new ExitSignVerifier());
    }

    @Override
    BannerComponentNode setupNode(BannerComponents components, int index, int startIndex, String modifier) {
        if (components.type().equals(EXIT)) {
            return null;
        }
        if (components.type().equals(EXIT_NUMBER)) {
            this.exitNumber = components.text();
            this.startIndex = startIndex;
            this.modifier = modifier;
        }
        return new BannerComponentNode(components, startIndex);
    }

    @Override
    void postProcess(TextView textView, List<BannerComponentNode> bannerComponentNodes) {
        if (this.exitNumber != null) {
            LayoutInflater inflater = (LayoutInflater)textView.getContext().getSystemService("layout_inflater");
            ViewGroup root = (ViewGroup)textView.getParent();
            TextView exitSignView = this.modifier.equals(LEFT) ? (TextView)inflater.inflate(R.layout.exit_sign_view_left, root, false) : (TextView)inflater.inflate(R.layout.exit_sign_view_right, root, false);
            exitSignView.setText((CharSequence)this.exitNumber);
            this.textViewUtils.setImageSpan(textView, (View)exitSignView, this.startIndex, this.startIndex + this.exitNumber.length());
        }
    }
}

