/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.camera;

import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.OnLifecycleEvent;
import android.location.Location;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.camera.CameraUpdate;
import com.mapbox.mapboxsdk.camera.CameraUpdateFactory;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.location.LocationComponent;
import com.mapbox.mapboxsdk.location.OnCameraTrackingChangedListener;
import com.mapbox.mapboxsdk.location.OnLocationCameraTransitionListener;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.services.android.navigation.ui.v5.camera.CameraAnimationDelegate;
import com.mapbox.services.android.navigation.ui.v5.camera.CameraOverviewCancelableCallback;
import com.mapbox.services.android.navigation.ui.v5.camera.DynamicCamera;
import com.mapbox.services.android.navigation.ui.v5.camera.NavigationCameraTrackingChangedListener;
import com.mapbox.services.android.navigation.ui.v5.camera.NavigationCameraTransitionListener;
import com.mapbox.services.android.navigation.ui.v5.camera.NavigationCameraUpdate;
import com.mapbox.services.android.navigation.ui.v5.camera.OnTrackingModeChangedListener;
import com.mapbox.services.android.navigation.ui.v5.camera.OnTrackingModeTransitionListener;
import com.mapbox.services.android.navigation.ui.v5.camera.ResetCancelableCallback;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigation;
import com.mapbox.services.android.navigation.v5.navigation.camera.Camera;
import com.mapbox.services.android.navigation.v5.navigation.camera.RouteInformation;
import com.mapbox.services.android.navigation.v5.routeprogress.ProgressChangeListener;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import com.mapbox.services.android.navigation.v5.utils.MathUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import timber.log.Timber;

public class NavigationCamera
implements LifecycleObserver {
    public static final int NAVIGATION_TRACKING_MODE_GPS = 0;
    public static final int NAVIGATION_TRACKING_MODE_NORTH = 1;
    public static final int NAVIGATION_TRACKING_MODE_NONE = 2;
    private static final int ONE_POINT = 1;
    private final CopyOnWriteArrayList<OnTrackingModeTransitionListener> onTrackingModeTransitionListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<OnTrackingModeChangedListener> onTrackingModeChangedListeners = new CopyOnWriteArrayList();
    private final OnLocationCameraTransitionListener cameraTransitionListener = new NavigationCameraTransitionListener(this);
    private final OnCameraTrackingChangedListener cameraTrackingChangedListener = new NavigationCameraTrackingChangedListener(this);
    private MapboxMap mapboxMap;
    private LocationComponent locationComponent;
    private MapboxNavigation navigation;
    private RouteInformation currentRouteInformation;
    private RouteProgress currentRouteProgress;
    private int trackingCameraMode = 0;
    private boolean isCameraResetting;
    private CameraAnimationDelegate animationDelegate;
    private ProgressChangeListener progressChangeListener = new ProgressChangeListener(){

        public void onProgressChange(Location location, RouteProgress routeProgress) {
            NavigationCamera.this.currentRouteProgress = routeProgress;
            if (NavigationCamera.this.isTrackingEnabled()) {
                NavigationCamera.this.currentRouteInformation = NavigationCamera.this.buildRouteInformationFromLocation(location, routeProgress);
                if (!NavigationCamera.this.isCameraResetting) {
                    NavigationCamera.this.adjustCameraFromLocation(NavigationCamera.this.currentRouteInformation);
                }
            }
        }
    };

    public NavigationCamera(@NonNull MapboxMap mapboxMap, @NonNull MapboxNavigation navigation, @NonNull LocationComponent locationComponent) {
        this.mapboxMap = mapboxMap;
        this.navigation = navigation;
        this.locationComponent = locationComponent;
        this.animationDelegate = new CameraAnimationDelegate(mapboxMap);
        this.locationComponent.addOnCameraTrackingChangedListener(this.cameraTrackingChangedListener);
        this.initializeWith(navigation);
    }

    public NavigationCamera(@NonNull MapboxMap mapboxMap, LocationComponent locationComponent) {
        this.mapboxMap = mapboxMap;
        this.locationComponent = locationComponent;
        this.animationDelegate = new CameraAnimationDelegate(mapboxMap);
        this.locationComponent.addOnCameraTrackingChangedListener(this.cameraTrackingChangedListener);
        this.updateCameraTrackingMode(this.trackingCameraMode);
    }

    NavigationCamera(MapboxMap mapboxMap, MapboxNavigation navigation, ProgressChangeListener progressChangeListener, LocationComponent locationComponent, RouteInformation currentRouteInformation) {
        this.mapboxMap = mapboxMap;
        this.locationComponent = locationComponent;
        this.navigation = navigation;
        this.progressChangeListener = progressChangeListener;
        this.currentRouteInformation = currentRouteInformation;
    }

    public void start(DirectionsRoute route) {
        if (route != null) {
            this.currentRouteInformation = this.buildRouteInformationFromRoute(route);
        }
        this.navigation.addProgressChangeListener(this.progressChangeListener);
    }

    public void resume(Location location) {
        if (location != null) {
            this.currentRouteInformation = this.buildRouteInformationFromLocation(location, null);
        }
        this.navigation.addProgressChangeListener(this.progressChangeListener);
    }

    public void updateCameraTrackingMode(int trackingMode) {
        this.setCameraMode(trackingMode);
    }

    public boolean isTrackingEnabled() {
        return this.trackingCameraMode != 2;
    }

    public int getCameraTrackingMode() {
        return this.trackingCameraMode;
    }

    public void resetCameraPositionWith(int trackingMode) {
        this.resetWith(trackingMode);
    }

    public void showRouteOverview(int[] padding) {
        this.updateCameraTrackingMode(2);
        RouteInformation routeInformation = this.buildRouteInformationFromProgress(this.currentRouteProgress);
        this.animateCameraForRouteOverview(routeInformation, padding);
    }

    public void update(NavigationCameraUpdate update) {
        this.animationDelegate.render(update, 300, null);
    }

    public void update(NavigationCameraUpdate update, int durationMs) {
        this.animationDelegate.render(update, durationMs, null);
    }

    public void update(NavigationCameraUpdate update, int durationMs, @Nullable MapboxMap.CancelableCallback callback) {
        this.animationDelegate.render(update, durationMs, callback);
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
    public void onStart() {
        if (this.navigation != null) {
            this.navigation.addProgressChangeListener(this.progressChangeListener);
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
    public void onStop() {
        if (this.navigation != null) {
            this.navigation.removeProgressChangeListener(this.progressChangeListener);
        }
    }

    public void addProgressChangeListener(MapboxNavigation navigation) {
        this.navigation = navigation;
        navigation.setCameraEngine((Camera)new DynamicCamera(this.mapboxMap));
        navigation.addProgressChangeListener(this.progressChangeListener);
    }

    public void addOnTrackingModeTransitionListener(@NonNull OnTrackingModeTransitionListener listener) {
        this.onTrackingModeTransitionListeners.add(listener);
    }

    public void removeOnTrackingModeTransitionListener(@NonNull OnTrackingModeTransitionListener listener) {
        this.onTrackingModeTransitionListeners.remove(listener);
    }

    public void addOnTrackingModeChangedListener(@NonNull OnTrackingModeChangedListener listener) {
        this.onTrackingModeChangedListeners.add(listener);
    }

    public void removeOnTrackingModeChangedListener(@NonNull OnTrackingModeChangedListener listener) {
        this.onTrackingModeChangedListeners.remove(listener);
    }

    void updateTransitionListenersFinished(int cameraMode) {
        this.onCameraTransitionFinished();
        Integer trackingCameraMode = this.findTrackingModeFor(cameraMode);
        if (trackingCameraMode == null) {
            return;
        }
        for (OnTrackingModeTransitionListener listener : this.onTrackingModeTransitionListeners) {
            listener.onTransitionFinished(trackingCameraMode);
        }
    }

    void updateTransitionListenersCancelled(int cameraMode) {
        Integer trackingCameraMode = this.findTrackingModeFor(cameraMode);
        if (trackingCameraMode == null) {
            return;
        }
        for (OnTrackingModeTransitionListener listener : this.onTrackingModeTransitionListeners) {
            listener.onTransitionCancelled(trackingCameraMode);
        }
    }

    @Nullable
    Integer findTrackingModeFor(int cameraMode) {
        if (cameraMode == 34) {
            return 0;
        }
        if (cameraMode == 36) {
            return 1;
        }
        if (cameraMode == 8) {
            return 2;
        }
        return null;
    }

    void updateIsResetting(boolean isResetting) {
        this.isCameraResetting = isResetting;
    }

    private void initializeWith(MapboxNavigation navigation) {
        navigation.setCameraEngine((Camera)new DynamicCamera(this.mapboxMap));
        this.updateCameraTrackingMode(this.trackingCameraMode);
    }

    @NonNull
    private RouteInformation buildRouteInformationFromRoute(DirectionsRoute route) {
        return RouteInformation.create((DirectionsRoute)route, null, null);
    }

    @NonNull
    private RouteInformation buildRouteInformationFromLocation(Location location, RouteProgress routeProgress) {
        return RouteInformation.create(null, (Location)location, (RouteProgress)routeProgress);
    }

    @NonNull
    private RouteInformation buildRouteInformationFromProgress(RouteProgress routeProgress) {
        if (routeProgress == null) {
            return RouteInformation.create(null, null, null);
        }
        return RouteInformation.create((DirectionsRoute)routeProgress.directionsRoute(), null, null);
    }

    private void onCameraTransitionFinished() {
        if (this.isCameraResetting && this.currentRouteInformation != null) {
            this.adjustCameraForReset(this.currentRouteInformation);
        }
    }

    private void animateCameraForRouteOverview(RouteInformation routeInformation, int[] padding) {
        Camera cameraEngine = this.navigation.getCameraEngine();
        List routePoints = cameraEngine.overview(routeInformation);
        if (!routePoints.isEmpty()) {
            this.animateMapboxMapForRouteOverview(padding, routePoints);
        }
    }

    private void animateMapboxMapForRouteOverview(int[] padding, List<Point> routePoints) {
        if (routePoints.size() <= 1) {
            return;
        }
        CameraUpdate resetUpdate = this.buildResetCameraUpdate();
        CameraUpdate overviewUpdate = this.buildOverviewCameraUpdate(padding, routePoints);
        this.mapboxMap.animateCamera(resetUpdate, 150, (MapboxMap.CancelableCallback)new CameraOverviewCancelableCallback(overviewUpdate, this.mapboxMap));
    }

    @NonNull
    private CameraUpdate buildResetCameraUpdate() {
        CameraPosition resetPosition = new CameraPosition.Builder().tilt(0.0).bearing(0.0).build();
        return CameraUpdateFactory.newCameraPosition((CameraPosition)resetPosition);
    }

    @NonNull
    private CameraUpdate buildOverviewCameraUpdate(int[] padding, List<Point> routePoints) {
        LatLngBounds routeBounds = this.convertRoutePointsToLatLngBounds(routePoints);
        return CameraUpdateFactory.newLatLngBounds((LatLngBounds)routeBounds, (int)padding[0], (int)padding[1], (int)padding[2], (int)padding[3]);
    }

    private LatLngBounds convertRoutePointsToLatLngBounds(List<Point> routePoints) {
        ArrayList<LatLng> latLngs = new ArrayList<LatLng>();
        for (Point routePoint : routePoints) {
            latLngs.add(new LatLng(routePoint.latitude(), routePoint.longitude()));
        }
        return new LatLngBounds.Builder().includes(latLngs).build();
    }

    private void setCameraMode(int trackingCameraMode) {
        Integer cameraMode = this.findCameraModeFor(trackingCameraMode);
        if (cameraMode != null) {
            this.trackingCameraMode = trackingCameraMode;
            this.updateTrackingModeListenersWith(this.trackingCameraMode);
            if (cameraMode.intValue() != this.locationComponent.getCameraMode()) {
                this.locationComponent.setCameraMode(cameraMode.intValue(), this.cameraTransitionListener);
            }
        } else {
            Timber.e((String)"Using unsupported camera tracking mode - %d.", (Object[])new Object[]{trackingCameraMode});
        }
    }

    @Nullable
    private Integer findCameraModeFor(int trackingCameraMode) {
        if (trackingCameraMode == 0) {
            return 34;
        }
        if (trackingCameraMode == 1) {
            return 36;
        }
        if (trackingCameraMode == 2) {
            return 8;
        }
        return null;
    }

    private void updateTrackingModeListenersWith(int trackingMode) {
        for (OnTrackingModeChangedListener listener : this.onTrackingModeChangedListeners) {
            listener.onTrackingModeChanged(trackingMode);
        }
    }

    private void resetWith(int trackingMode) {
        this.updateIsResetting(true);
        this.resetDynamicCamera(this.navigation.getCameraEngine());
        this.updateCameraTrackingMode(trackingMode);
    }

    private void resetDynamicCamera(Camera camera) {
        if (camera instanceof DynamicCamera) {
            ((DynamicCamera)camera).forceResetZoomLevel();
        }
    }

    private void adjustCameraForReset(RouteInformation routeInformation) {
        Camera camera = this.navigation.getCameraEngine();
        float tilt = (float)camera.tilt(routeInformation);
        double zoom = camera.zoom(routeInformation);
        this.locationComponent.zoomWhileTracking(zoom, this.getZoomAnimationDuration(zoom), (MapboxMap.CancelableCallback)new ResetCancelableCallback(this));
        this.locationComponent.tiltWhileTracking((double)tilt, this.getTiltAnimationDuration(tilt));
    }

    private void adjustCameraFromLocation(RouteInformation routeInformation) {
        Camera camera = this.navigation.getCameraEngine();
        float tilt = (float)camera.tilt(routeInformation);
        double zoom = camera.zoom(routeInformation);
        this.locationComponent.zoomWhileTracking(zoom, this.getZoomAnimationDuration(zoom));
        this.locationComponent.tiltWhileTracking((double)tilt, this.getTiltAnimationDuration(tilt));
    }

    private long getZoomAnimationDuration(double zoom) {
        double zoomDiff = Math.abs(this.mapboxMap.getCameraPosition().zoom - zoom);
        return (long)MathUtils.clamp((double)(500.0 * zoomDiff), (double)300.0, (double)1500.0);
    }

    private long getTiltAnimationDuration(double tilt) {
        double tiltDiff = Math.abs(this.mapboxMap.getCameraPosition().tilt - tilt);
        return (long)MathUtils.clamp((double)(500.0 * tiltDiff), (double)750.0, (double)1500.0);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TrackingMode {
    }
}

