/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.camera;

import com.mapbox.mapboxsdk.camera.CameraUpdate;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.services.android.navigation.ui.v5.camera.CameraUpdateMode;
import com.mapbox.services.android.navigation.ui.v5.camera.NavigationCameraUpdate;

class CameraAnimationDelegate {
    private final MapboxMap mapboxMap;

    CameraAnimationDelegate(MapboxMap mapboxMap) {
        this.mapboxMap = mapboxMap;
    }

    void render(NavigationCameraUpdate update, int durationMs, MapboxMap.CancelableCallback callback) {
        CameraUpdateMode mode = update.getMode();
        CameraUpdate cameraUpdate = update.getCameraUpdate();
        if (mode == CameraUpdateMode.OVERRIDE) {
            this.mapboxMap.getLocationComponent().setCameraMode(8);
            this.mapboxMap.animateCamera(cameraUpdate, durationMs, callback);
        } else if (!this.isTracking()) {
            this.mapboxMap.animateCamera(cameraUpdate, durationMs, callback);
        }
    }

    private boolean isTracking() {
        int cameraMode = this.mapboxMap.getLocationComponent().getCameraMode();
        return cameraMode != 8;
    }
}

