/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Parcelable;
import android.preference.PreferenceManager;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.services.android.navigation.ui.v5.MapboxNavigationActivity;
import com.mapbox.services.android.navigation.ui.v5.NavigationLauncherOptions;

public class NavigationLauncher {
    public static void startNavigation(Activity activity, NavigationLauncherOptions options) {
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)activity);
        SharedPreferences.Editor editor = preferences.edit();
        NavigationLauncher.storeDirectionsRouteValue(options, editor);
        NavigationLauncher.storeConfiguration(options, editor);
        NavigationLauncher.storeThemePreferences(options, editor);
        NavigationLauncher.storeOfflinePath(options, editor);
        NavigationLauncher.storeOfflineVersion(options, editor);
        if (options.offlineMapOptions() != null) {
            NavigationLauncher.storeOfflineMapDatabasePath(options, editor);
            NavigationLauncher.storeOfflineMapStyleUrl(options, editor);
        }
        editor.apply();
        Intent navigationActivity = new Intent((Context)activity, MapboxNavigationActivity.class);
        NavigationLauncher.storeInitialMapPosition(options, navigationActivity);
        activity.startActivity(navigationActivity);
    }

    static DirectionsRoute extractRoute(Context context) {
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        String directionsRouteJson = preferences.getString("route_json", "");
        return DirectionsRoute.fromJson((String)directionsRouteJson);
    }

    static void cleanUpPreferences(Context context) {
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        SharedPreferences.Editor editor = preferences.edit();
        editor.remove("route_json").remove("navigation_view_simulate_route").remove("navigation_view_theme_preference").remove("navigation_view_theme_preference").remove("navigation_view_light_theme").remove("navigation_view_dark_theme").remove("offline_path_key").remove("offline_version_key").remove("offline_map_database_path_key").remove("offline_map_style_url_key").apply();
    }

    private static void storeDirectionsRouteValue(NavigationLauncherOptions options, SharedPreferences.Editor editor) {
        editor.putString("route_json", options.directionsRoute().toJson());
    }

    private static void storeConfiguration(NavigationLauncherOptions options, SharedPreferences.Editor editor) {
        editor.putBoolean("navigation_view_simulate_route", options.shouldSimulateRoute());
    }

    private static void storeThemePreferences(NavigationLauncherOptions options, SharedPreferences.Editor editor) {
        boolean preferenceThemeSet = options.lightThemeResId() != null || options.darkThemeResId() != null;
        editor.putBoolean("navigation_view_theme_preference", preferenceThemeSet);
        if (preferenceThemeSet) {
            if (options.lightThemeResId() != null) {
                editor.putInt("navigation_view_light_theme", options.lightThemeResId().intValue());
            }
            if (options.darkThemeResId() != null) {
                editor.putInt("navigation_view_dark_theme", options.darkThemeResId().intValue());
            }
        }
    }

    private static void storeInitialMapPosition(NavigationLauncherOptions options, Intent navigationActivity) {
        if (options.initialMapCameraPosition() != null) {
            navigationActivity.putExtra("navigation_view_initial_map_position", (Parcelable)options.initialMapCameraPosition());
        }
    }

    private static void storeOfflinePath(NavigationLauncherOptions options, SharedPreferences.Editor editor) {
        editor.putString("offline_path_key", options.offlineRoutingTilesPath());
    }

    private static void storeOfflineVersion(NavigationLauncherOptions options, SharedPreferences.Editor editor) {
        editor.putString("offline_version_key", options.offlineRoutingTilesVersion());
    }

    private static void storeOfflineMapDatabasePath(NavigationLauncherOptions options, SharedPreferences.Editor editor) {
        editor.putString("offline_map_database_path_key", options.offlineMapOptions().getDatabasePath());
    }

    private static void storeOfflineMapStyleUrl(NavigationLauncherOptions options, SharedPreferences.Editor editor) {
        editor.putString("offline_map_style_url_key", options.offlineMapOptions().getStyleUrl());
    }
}

