/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import com.mapbox.services.android.navigation.ui.v5.MobileNetworkChecker;
import com.mapbox.services.android.navigation.ui.v5.WifiNetworkChecker;
import java.util.HashMap;

public class ConnectivityStatusProvider {
    private final Context context;
    private final WifiNetworkChecker wifiNetworkChecker;
    private final MobileNetworkChecker mobileNetworkChecker;

    public ConnectivityStatusProvider(Context applicationContext) {
        this.context = applicationContext;
        this.wifiNetworkChecker = new WifiNetworkChecker(new HashMap<Integer, Boolean>());
        this.mobileNetworkChecker = new MobileNetworkChecker(new HashMap<Integer, Boolean>());
    }

    public boolean isConnectedFast() {
        NetworkInfo info = this.getNetworkInfo(this.context);
        int wifiLevel = this.getWifiLevel(this.context);
        return info != null && info.isConnected() && this.isConnectionFast(info.getType(), info.getSubtype(), wifiLevel);
    }

    public boolean isConnected() {
        NetworkInfo info = this.getNetworkInfo(this.context);
        return info != null && info.isConnected();
    }

    @SuppressLint(value={"MissingPermission"})
    private NetworkInfo getNetworkInfo(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        return cm.getActiveNetworkInfo();
    }

    @SuppressLint(value={"MissingPermission", "WifiManagerPotentialLeak"})
    private int getWifiLevel(Context context) {
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        int numberOfLevels = 5;
        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
        return WifiManager.calculateSignalLevel((int)wifiInfo.getRssi(), (int)numberOfLevels);
    }

    private boolean isConnectionFast(int type, int networkType, int wifiLevel) {
        if (type == 1) {
            return this.wifiNetworkChecker.isFast(wifiLevel);
        }
        if (type == 0) {
            return this.mobileNetworkChecker.isFast(networkType);
        }
        return false;
    }
}

