/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.voice;

import android.content.Context;
import android.media.MediaPlayer;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.v4.util.Pair;
import android.text.TextUtils;
import com.mapbox.services.android.navigation.ui.v5.voice.SpeechAnnouncement;
import com.mapbox.services.android.navigation.ui.v5.voice.SpeechAnnouncementMap;
import com.mapbox.services.android.navigation.ui.v5.voice.SpeechAnnouncementUpdate;
import com.mapbox.services.android.navigation.ui.v5.voice.SpeechListener;
import com.mapbox.services.android.navigation.ui.v5.voice.SpeechPlayer;
import com.mapbox.services.android.navigation.ui.v5.voice.VoiceInstructionLoader;
import com.mapbox.services.android.navigation.v5.utils.DownloadTask;
import java.io.File;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import timber.log.Timber;

class MapboxSpeechPlayer
implements SpeechPlayer {
    private static final String MAPBOX_INSTRUCTION_CACHE = "mapbox_instruction_cache";
    private static final String ERROR_TEXT = "Unable to set data source for the media mediaPlayer! %s";
    private static final SpeechAnnouncementMap SPEECH_ANNOUNCEMENT_MAP = new SpeechAnnouncementMap();
    private static final String MP3_POSTFIX = "mp3";
    private SpeechAnnouncement announcement;
    private SpeechListener speechListener;
    private MediaPlayer mediaPlayer;
    private Queue<File> instructionQueue;
    private File mapboxCache;
    private boolean isPlaying;
    private boolean isMuted;
    private VoiceInstructionLoader voiceInstructionLoader;

    MapboxSpeechPlayer(Context context, @NonNull SpeechListener speechListener, VoiceInstructionLoader voiceInstructionLoader) {
        this.speechListener = speechListener;
        this.voiceInstructionLoader = voiceInstructionLoader;
        this.setupCaches(context);
        this.instructionQueue = new ConcurrentLinkedQueue<File>();
    }

    @Override
    public void play(SpeechAnnouncement announcement) {
        boolean isInvalidAnnouncement;
        boolean bl = isInvalidAnnouncement = announcement == null;
        if (isInvalidAnnouncement) {
            return;
        }
        this.announcement = announcement;
        this.playAnnouncementTextAndTypeFrom(announcement);
    }

    @Override
    public boolean isMuted() {
        return this.isMuted;
    }

    @Override
    public void setMuted(boolean isMuted) {
        this.isMuted = isMuted;
        this.muteSpeech();
    }

    @Override
    public void onOffRoute() {
        this.pauseInstruction();
        this.clearInstructionUrls();
    }

    @Override
    public void onDestroy() {
        this.stopMediaPlayerPlaying();
        this.voiceInstructionLoader.flushCache();
    }

    private void setupCaches(Context context) {
        this.mapboxCache = new File(context.getCacheDir(), MAPBOX_INSTRUCTION_CACHE);
        this.mapboxCache.mkdir();
    }

    private void playAnnouncementTextAndTypeFrom(SpeechAnnouncement announcement) {
        boolean hasSsmlAnnouncement = announcement.ssmlAnnouncement() != null;
        SpeechAnnouncementUpdate speechAnnouncementUpdate = (SpeechAnnouncementUpdate)SPEECH_ANNOUNCEMENT_MAP.get(hasSsmlAnnouncement);
        Pair<String, String> textAndType = speechAnnouncementUpdate.buildTextAndTypeFrom(announcement);
        this.playAnnouncementText((String)textAndType.first, (String)textAndType.second);
    }

    private void playAnnouncementText(String instruction, String textType) {
        this.downloadVoiceFile(instruction, textType);
    }

    private void muteSpeech() {
        if (this.isMuted) {
            this.stopMediaPlayerPlaying();
            this.clearInstructionUrls();
        }
    }

    private void stopMediaPlayerPlaying() {
        if (this.isPlaying) {
            this.isPlaying = false;
            this.mediaPlayer.stop();
            this.mediaPlayer.release();
            this.speechListener.onDone();
        }
    }

    private void downloadVoiceFile(String instruction, String textType) {
        boolean isInvalidInstruction = TextUtils.isEmpty((CharSequence)instruction);
        if (this.isMuted || isInvalidInstruction) {
            return;
        }
        this.voiceInstructionLoader.requestInstruction(instruction, textType, new Callback<ResponseBody>(){

            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                if (response.isSuccessful()) {
                    MapboxSpeechPlayer.this.executeInstructionTask((ResponseBody)response.body());
                } else {
                    try {
                        MapboxSpeechPlayer.this.onError(response.errorBody().string());
                    }
                    catch (IOException exception) {
                        MapboxSpeechPlayer.this.onError(exception.getLocalizedMessage());
                    }
                }
            }

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                MapboxSpeechPlayer.this.onError(throwable.getLocalizedMessage());
            }
        });
    }

    private void onError(String errorText) {
        this.speechListener.onError(errorText, this.announcement);
    }

    private void playInstruction(@NonNull File instruction) {
        this.setupMediaPlayer(instruction.getPath());
    }

    private void setupMediaPlayer(String instructionPath) {
        if (TextUtils.isEmpty((CharSequence)instructionPath)) {
            return;
        }
        this.mediaPlayer = new MediaPlayer();
        this.setDataSource(instructionPath);
        this.mediaPlayer.prepareAsync();
        this.addListeners();
    }

    private void pauseInstruction() {
        if (this.isPlaying) {
            this.isPlaying = false;
            this.mediaPlayer.stop();
        }
    }

    private void setDataSource(String instruction) {
        try {
            this.mediaPlayer.setDataSource(instruction);
        }
        catch (IOException ioException) {
            Timber.e((String)ERROR_TEXT, (Object[])new Object[]{ioException.getMessage()});
        }
    }

    private void addListeners() {
        this.mediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mp) {
                MapboxSpeechPlayer.this.speechListener.onStart();
                MapboxSpeechPlayer.this.isPlaying = true;
                mp.start();
            }
        });
        this.mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mp) {
                mp.release();
                MapboxSpeechPlayer.this.isPlaying = false;
                MapboxSpeechPlayer.this.speechListener.onDone();
                MapboxSpeechPlayer.this.onInstructionFinishedPlaying();
            }
        });
    }

    private void onInstructionFinishedPlaying() {
        this.deleteLastInstructionPlayed();
        this.startNextInstruction();
    }

    private void deleteLastInstructionPlayed() {
        if (!this.instructionQueue.isEmpty()) {
            this.instructionQueue.poll().delete();
        }
    }

    private void startNextInstruction() {
        if (!this.instructionQueue.isEmpty()) {
            this.playInstruction(this.instructionQueue.peek());
        }
    }

    private void clearInstructionUrls() {
        while (!this.instructionQueue.isEmpty()) {
            this.instructionQueue.remove().delete();
        }
    }

    private void executeInstructionTask(ResponseBody responseBody) {
        new DownloadTask(this.mapboxCache.getPath(), MP3_POSTFIX, new DownloadTask.DownloadListener(){

            public void onFinishedDownloading(@NonNull File instructionFile) {
                MapboxSpeechPlayer.this.playInstructionIfUpNext(instructionFile);
                MapboxSpeechPlayer.this.instructionQueue.add(instructionFile);
            }

            public void onErrorDownloading() {
                MapboxSpeechPlayer.this.onError("There was an error downloading the voice files.");
            }
        }).executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, (Object[])new ResponseBody[]{responseBody});
    }

    private void playInstructionIfUpNext(File instructionFile) {
        if (this.instructionQueue.isEmpty()) {
            this.playInstruction(instructionFile);
        }
    }
}

