/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.utils;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.util.Base64;
import android.view.View;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class ViewUtils {
    public static Bitmap captureView(View view) {
        View rootView = view.getRootView();
        rootView.setDrawingCacheEnabled(true);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)rootView.getDrawingCache());
        rootView.setDrawingCacheEnabled(false);
        return bitmap;
    }

    public static String encodeView(Bitmap capture) {
        int width = 250;
        int height = Math.round((float)width * (float)capture.getHeight() / (float)capture.getWidth());
        Bitmap scaled = Bitmap.createScaledBitmap((Bitmap)capture, (int)width, (int)height, (boolean)true);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        scaled.compress(Bitmap.CompressFormat.JPEG, 20, (OutputStream)stream);
        byte[] data = stream.toByteArray();
        return Base64.encodeToString((byte[])data, (int)0);
    }

    public static Bitmap loadBitmapFromView(View view) {
        if (view.getMeasuredHeight() <= 0) {
            view.measure(-2, -2);
            Bitmap bitmap = Bitmap.createBitmap((int)view.getMeasuredWidth(), (int)view.getMeasuredHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            view.layout(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
            view.draw(canvas);
            return bitmap;
        }
        return null;
    }
}

