/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.route;

import android.location.Location;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.services.android.navigation.ui.v5.route.MapRouteArrow;
import com.mapbox.services.android.navigation.ui.v5.route.MapRouteLine;
import com.mapbox.services.android.navigation.v5.routeprogress.ProgressChangeListener;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import java.util.List;

class MapRouteProgressChangeListener
implements ProgressChangeListener {
    private final MapRouteLine routeLine;
    private final MapRouteArrow routeArrow;
    private boolean isVisible = true;

    MapRouteProgressChangeListener(MapRouteLine routeLine, MapRouteArrow routeArrow) {
        this.routeLine = routeLine;
        this.routeArrow = routeArrow;
    }

    public void onProgressChange(Location location, RouteProgress routeProgress) {
        if (!this.isVisible) {
            return;
        }
        DirectionsRoute currentRoute = routeProgress.directionsRoute();
        List<DirectionsRoute> directionsRoutes = this.routeLine.retrieveDirectionsRoutes();
        int primaryRouteIndex = this.routeLine.retrievePrimaryRouteIndex();
        this.addNewRoute(currentRoute, directionsRoutes, primaryRouteIndex);
        this.routeArrow.addUpcomingManeuverArrow(routeProgress);
    }

    void updateVisibility(boolean isVisible) {
        this.isVisible = isVisible;
    }

    private void addNewRoute(DirectionsRoute currentRoute, List<DirectionsRoute> directionsRoutes, int primaryRouteIndex) {
        if (this.isANewRoute(currentRoute, directionsRoutes, primaryRouteIndex)) {
            this.routeLine.draw(currentRoute);
        }
    }

    private boolean isANewRoute(DirectionsRoute currentRoute, List<DirectionsRoute> directionsRoutes, int primaryRouteIndex) {
        boolean noRoutes = directionsRoutes.isEmpty();
        return noRoutes || !currentRoute.equals(directionsRoutes.get(primaryRouteIndex));
    }
}

