/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.route;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v7.content.res.AppCompatResources;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.api.directions.v5.models.LegStep;
import com.mapbox.api.directions.v5.models.RouteLeg;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.LineLayer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.SymbolLayer;
import com.mapbox.mapboxsdk.style.sources.GeoJsonOptions;
import com.mapbox.mapboxsdk.style.sources.GeoJsonSource;
import com.mapbox.mapboxsdk.style.sources.Source;
import com.mapbox.services.android.navigation.ui.v5.R;
import com.mapbox.services.android.navigation.ui.v5.route.FeatureProcessingTask;
import com.mapbox.services.android.navigation.ui.v5.route.OnPrimaryRouteUpdatedCallback;
import com.mapbox.services.android.navigation.ui.v5.route.OnRouteFeaturesProcessedCallback;
import com.mapbox.services.android.navigation.ui.v5.route.PrimaryRouteUpdateTask;
import com.mapbox.services.android.navigation.ui.v5.utils.MapImageUtils;
import com.mapbox.services.android.navigation.ui.v5.utils.MapUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class MapRouteLine {
    @ColorInt
    private int routeDefaultColor;
    @ColorInt
    private int routeModerateColor;
    @ColorInt
    private int routeSevereColor;
    @ColorInt
    private int alternativeRouteDefaultColor;
    @ColorInt
    private int alternativeRouteModerateColor;
    @ColorInt
    private int alternativeRouteSevereColor;
    @ColorInt
    private int alternativeRouteShieldColor;
    @ColorInt
    private int routeShieldColor;
    private float routeScale;
    private float alternativeRouteScale;
    private final HashMap<LineString, DirectionsRoute> routeLineStrings = new HashMap();
    private final List<FeatureCollection> routeFeatureCollections = new ArrayList<FeatureCollection>();
    private final List<DirectionsRoute> directionsRoutes = new ArrayList<DirectionsRoute>();
    private final List<Layer> routeLayers;
    private MapboxMap mapboxMap;
    private Drawable originIcon;
    private Drawable destinationIcon;
    private GeoJsonSource wayPointSource;
    private GeoJsonSource routeLineSource;
    private String belowLayer;
    private int primaryRouteIndex;
    private boolean isVisible = true;
    private boolean alternativesVisible = true;
    private OnRouteFeaturesProcessedCallback routeFeaturesProcessedCallback = new OnRouteFeaturesProcessedCallback(){

        @Override
        public void onRouteFeaturesProcessed(List<FeatureCollection> routeFeatureCollections, HashMap<LineString, DirectionsRoute> routeLineStrings) {
            MapRouteLine.this.routeFeatureCollections.addAll(routeFeatureCollections);
            MapRouteLine.this.routeLineStrings.putAll(routeLineStrings);
            MapRouteLine.this.drawRoutes(routeFeatureCollections);
            MapRouteLine.this.drawWayPoints();
            MapRouteLine.this.updateAlternativeVisibilityTo(MapRouteLine.this.alternativesVisible);
            MapRouteLine.this.updateRoutesFor(MapRouteLine.this.primaryRouteIndex);
            MapRouteLine.this.updateVisibilityTo(MapRouteLine.this.isVisible);
        }
    };
    private OnPrimaryRouteUpdatedCallback primaryRouteUpdatedCallback = new OnPrimaryRouteUpdatedCallback(){

        @Override
        public void onPrimaryRouteUpdated(List<FeatureCollection> updatedRouteCollections) {
            MapRouteLine.this.drawRoutes(updatedRouteCollections);
        }
    };

    MapRouteLine(Context context, MapboxMap mapboxMap, int styleRes, String belowLayer) {
        this.mapboxMap = mapboxMap;
        this.belowLayer = belowLayer;
        this.routeLayers = new ArrayList<Layer>();
        TypedArray typedArray = context.obtainStyledAttributes(styleRes, R.styleable.NavigationMapRoute);
        this.routeDefaultColor = typedArray.getColor(R.styleable.NavigationMapRoute_routeColor, ContextCompat.getColor((Context)context, (int)R.color.mapbox_navigation_route_layer_blue));
        this.routeModerateColor = typedArray.getColor(R.styleable.NavigationMapRoute_routeModerateCongestionColor, ContextCompat.getColor((Context)context, (int)R.color.mapbox_navigation_route_layer_congestion_yellow));
        this.routeSevereColor = typedArray.getColor(R.styleable.NavigationMapRoute_routeSevereCongestionColor, ContextCompat.getColor((Context)context, (int)R.color.mapbox_navigation_route_layer_congestion_red));
        this.routeShieldColor = typedArray.getColor(R.styleable.NavigationMapRoute_routeShieldColor, ContextCompat.getColor((Context)context, (int)R.color.mapbox_navigation_route_shield_layer_color));
        this.routeScale = typedArray.getFloat(R.styleable.NavigationMapRoute_routeScale, 1.0f);
        this.alternativeRouteDefaultColor = typedArray.getColor(R.styleable.NavigationMapRoute_alternativeRouteColor, ContextCompat.getColor((Context)context, (int)R.color.mapbox_navigation_route_alternative_color));
        this.alternativeRouteModerateColor = typedArray.getColor(R.styleable.NavigationMapRoute_alternativeRouteModerateCongestionColor, ContextCompat.getColor((Context)context, (int)R.color.mapbox_navigation_route_alternative_congestion_yellow));
        this.alternativeRouteSevereColor = typedArray.getColor(R.styleable.NavigationMapRoute_alternativeRouteSevereCongestionColor, ContextCompat.getColor((Context)context, (int)R.color.mapbox_navigation_route_alternative_congestion_red));
        this.alternativeRouteShieldColor = typedArray.getColor(R.styleable.NavigationMapRoute_alternativeRouteShieldColor, ContextCompat.getColor((Context)context, (int)R.color.mapbox_navigation_route_alternative_shield_color));
        this.alternativeRouteScale = typedArray.getFloat(R.styleable.NavigationMapRoute_alternativeRouteScale, 1.0f);
        int originWaypointIcon = typedArray.getResourceId(R.styleable.NavigationMapRoute_originWaypointIcon, R.drawable.ic_route_origin);
        int destinationWaypointIcon = typedArray.getResourceId(R.styleable.NavigationMapRoute_destinationWaypointIcon, R.drawable.ic_route_destination);
        typedArray.recycle();
        this.originIcon = AppCompatResources.getDrawable((Context)context, (int)originWaypointIcon);
        this.destinationIcon = AppCompatResources.getDrawable((Context)context, (int)destinationWaypointIcon);
        this.findRouteBelowLayerId();
        GeoJsonOptions wayPointGeoJsonOptions = new GeoJsonOptions().withMaxZoom(16);
        FeatureCollection emptyWayPointFeatureCollection = FeatureCollection.fromFeatures((Feature[])new Feature[0]);
        this.wayPointSource = new GeoJsonSource("mapbox-navigation-waypoint-source", emptyWayPointFeatureCollection, wayPointGeoJsonOptions);
        mapboxMap.getStyle().addSource((Source)this.wayPointSource);
        GeoJsonOptions routeLineGeoJsonOptions = new GeoJsonOptions().withMaxZoom(16);
        FeatureCollection emptyRouteLineFeatureCollection = FeatureCollection.fromFeatures((Feature[])new Feature[0]);
        this.routeLineSource = new GeoJsonSource("mapbox-navigation-route-source", emptyRouteLineFeatureCollection, routeLineGeoJsonOptions);
        mapboxMap.getStyle().addSource((Source)this.routeLineSource);
        this.initializeLayers(mapboxMap);
    }

    MapRouteLine(GeoJsonSource routeLineSource, GeoJsonSource wayPointSource, List<Layer> routeLayers) {
        this.routeLineSource = routeLineSource;
        this.wayPointSource = wayPointSource;
        this.routeLayers = routeLayers;
    }

    void draw(DirectionsRoute directionsRoute) {
        ArrayList<DirectionsRoute> route = new ArrayList<DirectionsRoute>();
        route.add(directionsRoute);
        this.draw(route);
    }

    void draw(List<DirectionsRoute> directionsRoutes) {
        if (directionsRoutes.isEmpty()) {
            return;
        }
        this.clearRouteData();
        this.directionsRoutes.addAll(directionsRoutes);
        this.primaryRouteIndex = 0;
        this.alternativesVisible = directionsRoutes.size() > 1;
        this.isVisible = true;
        this.generateRouteFeatureCollectionsFrom(directionsRoutes);
    }

    void redraw(List<DirectionsRoute> routes, boolean alternativesVisible, int primaryRouteIndex, boolean isVisible) {
        this.draw(routes);
        this.alternativesVisible = alternativesVisible;
        this.primaryRouteIndex = primaryRouteIndex;
        this.isVisible = isVisible;
    }

    void toggleAlternativeVisibilityWith(boolean alternativesVisible) {
        this.alternativesVisible = alternativesVisible;
        this.updateAlternativeVisibilityTo(alternativesVisible);
    }

    boolean retrieveAlternativesVisible() {
        return this.alternativesVisible;
    }

    void updateVisibilityTo(boolean isVisible) {
        this.updateAllLayersVisibilityTo(isVisible);
    }

    boolean retrieveVisibility() {
        return this.isVisible;
    }

    HashMap<LineString, DirectionsRoute> retrieveRouteLineStrings() {
        return this.routeLineStrings;
    }

    List<DirectionsRoute> retrieveDirectionsRoutes() {
        return this.directionsRoutes;
    }

    boolean updatePrimaryRouteIndex(int primaryRouteIndex) {
        boolean isNewIndex;
        boolean bl = isNewIndex = this.primaryRouteIndex != primaryRouteIndex && primaryRouteIndex < this.directionsRoutes.size();
        if (isNewIndex) {
            this.primaryRouteIndex = primaryRouteIndex;
            this.updateRoutesFor(primaryRouteIndex);
        }
        return isNewIndex;
    }

    int retrievePrimaryRouteIndex() {
        return this.primaryRouteIndex;
    }

    private void drawRoutes(List<FeatureCollection> routeFeatureCollections) {
        ArrayList routeFeatures = new ArrayList();
        for (int i = routeFeatureCollections.size() - 1; i >= 0; --i) {
            routeFeatures.addAll(routeFeatureCollections.get(i).features());
        }
        this.routeLineSource.setGeoJson(FeatureCollection.fromFeatures(routeFeatures));
    }

    private void clearRouteData() {
        this.clearRouteListData();
        this.resetSource(this.wayPointSource);
        this.resetSource(this.routeLineSource);
    }

    private void clearRouteListData() {
        if (!this.directionsRoutes.isEmpty()) {
            this.directionsRoutes.clear();
        }
        if (!this.routeLineStrings.isEmpty()) {
            this.routeLineStrings.clear();
        }
        if (!this.routeFeatureCollections.isEmpty()) {
            this.routeFeatureCollections.clear();
        }
    }

    private void generateRouteFeatureCollectionsFrom(List<DirectionsRoute> routes) {
        new FeatureProcessingTask(routes, this.routeFeaturesProcessedCallback).execute(new Void[0]);
    }

    private void drawWayPoints() {
        DirectionsRoute primaryRoute = this.directionsRoutes.get(this.primaryRouteIndex);
        FeatureCollection wayPointFeatureCollection = this.buildWayPointFeatureCollectionFrom(primaryRoute);
        this.wayPointSource.setGeoJson(wayPointFeatureCollection);
    }

    private FeatureCollection buildWayPointFeatureCollectionFrom(DirectionsRoute route) {
        ArrayList<Feature> wayPointFeatures = new ArrayList<Feature>();
        for (RouteLeg leg : route.legs()) {
            wayPointFeatures.add(this.buildWayPointFeatureFromLeg(leg, 0));
            wayPointFeatures.add(this.buildWayPointFeatureFromLeg(leg, leg.steps().size() - 1));
        }
        return FeatureCollection.fromFeatures(wayPointFeatures);
    }

    private Feature buildWayPointFeatureFromLeg(RouteLeg leg, int index) {
        Feature feature = Feature.fromGeometry((Geometry)Point.fromLngLat((double)((LegStep)leg.steps().get(index)).maneuver().location().longitude(), (double)((LegStep)leg.steps().get(index)).maneuver().location().latitude()));
        feature.addStringProperty("wayPoint", index == 0 ? "origin" : "destination");
        return feature;
    }

    private void updateRoutesFor(int newPrimaryIndex) {
        if (newPrimaryIndex < 0 || newPrimaryIndex > this.routeFeatureCollections.size() - 1) {
            return;
        }
        new PrimaryRouteUpdateTask(newPrimaryIndex, this.routeFeatureCollections, this.primaryRouteUpdatedCallback).execute(new Void[0]);
    }

    private void findRouteBelowLayerId() {
        if (this.belowLayer == null || this.belowLayer.isEmpty()) {
            List styleLayers = this.mapboxMap.getStyle().getLayers();
            for (int i = 0; i < styleLayers.size(); ++i) {
                if (styleLayers.get(i) instanceof SymbolLayer || ((Layer)styleLayers.get(i)).getId().contains("mapbox-location")) continue;
                this.belowLayer = ((Layer)styleLayers.get(i)).getId();
            }
        }
    }

    private void initializeLayers(MapboxMap mapboxMap) {
        LineLayer routeShieldLayer = this.initializeRouteShieldLayer(mapboxMap);
        MapUtils.addLayerToMap(mapboxMap, (Layer)routeShieldLayer, this.belowLayer);
        this.routeLayers.add((Layer)routeShieldLayer);
        LineLayer routeLayer = this.initializeRouteLayer(mapboxMap);
        MapUtils.addLayerToMap(mapboxMap, (Layer)routeLayer, this.belowLayer);
        this.routeLayers.add((Layer)routeLayer);
        SymbolLayer wayPointLayer = this.initializeWayPointLayer(mapboxMap);
        MapUtils.addLayerToMap(mapboxMap, (Layer)wayPointLayer, this.belowLayer);
        this.routeLayers.add((Layer)wayPointLayer);
    }

    private LineLayer initializeRouteShieldLayer(MapboxMap mapboxMap) {
        LineLayer shieldLayer = (LineLayer)mapboxMap.getStyle().getLayerAs("mapbox-navigation-route-shield-layer");
        if (shieldLayer != null) {
            mapboxMap.getStyle().removeLayer((Layer)shieldLayer);
        }
        shieldLayer = new LineLayer("mapbox-navigation-route-shield-layer", "mapbox-navigation-route-source").withProperties(new PropertyValue[]{PropertyFactory.lineCap((String)"round"), PropertyFactory.lineJoin((String)"round"), PropertyFactory.lineWidth((Expression)Expression.interpolate((Expression.Interpolator)Expression.exponential((Number)Float.valueOf(1.5f)), (Expression)Expression.zoom(), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)Float.valueOf(10.0f), (Object)Float.valueOf(7.0f)), Expression.stop((Object)Float.valueOf(14.0f), (Object)Expression.product((Expression[])new Expression[]{Expression.literal((Number)Float.valueOf(10.5f)), Expression.switchCase((Expression[])new Expression[]{Expression.get((String)"primary-route"), Expression.literal((Number)Float.valueOf(this.routeScale)), Expression.literal((Number)Float.valueOf(this.alternativeRouteScale))})})), Expression.stop((Object)Float.valueOf(16.5f), (Object)Expression.product((Expression[])new Expression[]{Expression.literal((Number)Float.valueOf(15.5f)), Expression.switchCase((Expression[])new Expression[]{Expression.get((String)"primary-route"), Expression.literal((Number)Float.valueOf(this.routeScale)), Expression.literal((Number)Float.valueOf(this.alternativeRouteScale))})})), Expression.stop((Object)Float.valueOf(19.0f), (Object)Expression.product((Expression[])new Expression[]{Expression.literal((Number)Float.valueOf(24.0f)), Expression.switchCase((Expression[])new Expression[]{Expression.get((String)"primary-route"), Expression.literal((Number)Float.valueOf(this.routeScale)), Expression.literal((Number)Float.valueOf(this.alternativeRouteScale))})})), Expression.stop((Object)Float.valueOf(22.0f), (Object)Expression.product((Expression[])new Expression[]{Expression.literal((Number)Float.valueOf(29.0f)), Expression.switchCase((Expression[])new Expression[]{Expression.get((String)"primary-route"), Expression.literal((Number)Float.valueOf(this.routeScale)), Expression.literal((Number)Float.valueOf(this.alternativeRouteScale))})}))})), PropertyFactory.lineColor((Expression)Expression.switchCase((Expression[])new Expression[]{Expression.get((String)"primary-route"), Expression.color((int)this.routeShieldColor), Expression.color((int)this.alternativeRouteShieldColor)}))});
        return shieldLayer;
    }

    private LineLayer initializeRouteLayer(MapboxMap mapboxMap) {
        LineLayer routeLayer = (LineLayer)mapboxMap.getStyle().getLayerAs("mapbox-navigation-route-layer");
        if (routeLayer != null) {
            mapboxMap.getStyle().removeLayer((Layer)routeLayer);
        }
        routeLayer = new LineLayer("mapbox-navigation-route-layer", "mapbox-navigation-route-source").withProperties(new PropertyValue[]{PropertyFactory.lineCap((String)"round"), PropertyFactory.lineJoin((String)"round"), PropertyFactory.lineWidth((Expression)Expression.interpolate((Expression.Interpolator)Expression.exponential((Number)Float.valueOf(1.5f)), (Expression)Expression.zoom(), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)Float.valueOf(4.0f), (Object)Expression.product((Expression[])new Expression[]{Expression.literal((Number)Float.valueOf(3.0f)), Expression.switchCase((Expression[])new Expression[]{Expression.get((String)"primary-route"), Expression.literal((Number)Float.valueOf(this.routeScale)), Expression.literal((Number)Float.valueOf(this.alternativeRouteScale))})})), Expression.stop((Object)Float.valueOf(10.0f), (Object)Expression.product((Expression[])new Expression[]{Expression.literal((Number)Float.valueOf(4.0f)), Expression.switchCase((Expression[])new Expression[]{Expression.get((String)"primary-route"), Expression.literal((Number)Float.valueOf(this.routeScale)), Expression.literal((Number)Float.valueOf(this.alternativeRouteScale))})})), Expression.stop((Object)Float.valueOf(13.0f), (Object)Expression.product((Expression[])new Expression[]{Expression.literal((Number)Float.valueOf(6.0f)), Expression.switchCase((Expression[])new Expression[]{Expression.get((String)"primary-route"), Expression.literal((Number)Float.valueOf(this.routeScale)), Expression.literal((Number)Float.valueOf(this.alternativeRouteScale))})})), Expression.stop((Object)Float.valueOf(16.0f), (Object)Expression.product((Expression[])new Expression[]{Expression.literal((Number)Float.valueOf(10.0f)), Expression.switchCase((Expression[])new Expression[]{Expression.get((String)"primary-route"), Expression.literal((Number)Float.valueOf(this.routeScale)), Expression.literal((Number)Float.valueOf(this.alternativeRouteScale))})})), Expression.stop((Object)Float.valueOf(19.0f), (Object)Expression.product((Expression[])new Expression[]{Expression.literal((Number)Float.valueOf(14.0f)), Expression.switchCase((Expression[])new Expression[]{Expression.get((String)"primary-route"), Expression.literal((Number)Float.valueOf(this.routeScale)), Expression.literal((Number)Float.valueOf(this.alternativeRouteScale))})})), Expression.stop((Object)Float.valueOf(22.0f), (Object)Expression.product((Expression[])new Expression[]{Expression.literal((Number)Float.valueOf(18.0f)), Expression.switchCase((Expression[])new Expression[]{Expression.get((String)"primary-route"), Expression.literal((Number)Float.valueOf(this.routeScale)), Expression.literal((Number)Float.valueOf(this.alternativeRouteScale))})}))})), PropertyFactory.lineColor((Expression)Expression.switchCase((Expression[])new Expression[]{Expression.get((String)"primary-route"), Expression.match((Expression)Expression.toString((Expression)Expression.get((String)"congestion")), (Expression)Expression.color((int)this.routeDefaultColor), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)"moderate", (Object)Expression.color((int)this.routeModerateColor)), Expression.stop((Object)"heavy", (Object)Expression.color((int)this.routeSevereColor)), Expression.stop((Object)"severe", (Object)Expression.color((int)this.routeSevereColor))}), Expression.match((Expression)Expression.toString((Expression)Expression.get((String)"congestion")), (Expression)Expression.color((int)this.alternativeRouteDefaultColor), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)"moderate", (Object)Expression.color((int)this.alternativeRouteModerateColor)), Expression.stop((Object)"heavy", (Object)Expression.color((int)this.alternativeRouteSevereColor)), Expression.stop((Object)"severe", (Object)Expression.color((int)this.alternativeRouteSevereColor))})}))});
        return routeLayer;
    }

    private SymbolLayer initializeWayPointLayer(@NonNull MapboxMap mapboxMap) {
        SymbolLayer wayPointLayer = (SymbolLayer)mapboxMap.getStyle().getLayerAs("mapbox-navigation-waypoint-layer");
        if (wayPointLayer != null) {
            mapboxMap.getStyle().removeLayer((Layer)wayPointLayer);
        }
        Bitmap bitmap = MapImageUtils.getBitmapFromDrawable(this.originIcon);
        mapboxMap.getStyle().addImage("originMarker", bitmap);
        bitmap = MapImageUtils.getBitmapFromDrawable(this.destinationIcon);
        mapboxMap.getStyle().addImage("destinationMarker", bitmap);
        wayPointLayer = new SymbolLayer("mapbox-navigation-waypoint-layer", "mapbox-navigation-waypoint-source").withProperties(new PropertyValue[]{PropertyFactory.iconImage((Expression)Expression.match((Expression)Expression.toString((Expression)Expression.get((String)"wayPoint")), (Expression)Expression.literal((String)"originMarker"), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)"origin", (Object)Expression.literal((String)"originMarker")), Expression.stop((Object)"destination", (Object)Expression.literal((String)"destinationMarker"))})), PropertyFactory.iconSize((Expression)Expression.interpolate((Expression.Interpolator)Expression.exponential((Number)Float.valueOf(1.5f)), (Expression)Expression.zoom(), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.6f)), Expression.stop((Object)Float.valueOf(10.0f), (Object)Float.valueOf(0.8f)), Expression.stop((Object)Float.valueOf(12.0f), (Object)Float.valueOf(1.3f)), Expression.stop((Object)Float.valueOf(22.0f), (Object)Float.valueOf(2.8f))})), PropertyFactory.iconPitchAlignment((String)"map"), PropertyFactory.iconAllowOverlap((Boolean)true), PropertyFactory.iconIgnorePlacement((Boolean)true)});
        return wayPointLayer;
    }

    private void updateAlternativeVisibilityTo(boolean isVisible) {
        for (Layer layer : this.routeLayers) {
            String layerId = layer.getId();
            if (!layerId.equals("mapbox-navigation-route-layer") && !layerId.equals("mapbox-navigation-route-shield-layer")) continue;
            LineLayer route = (LineLayer)layer;
            if (isVisible) {
                route.setFilter(Expression.literal((boolean)true));
                continue;
            }
            route.setFilter(Expression.eq((Expression)Expression.get((String)"primary-route"), (boolean)true));
        }
    }

    private void updateAllLayersVisibilityTo(boolean isVisible) {
        this.isVisible = isVisible;
        for (Layer layer : this.routeLayers) {
            layer.setProperties(new PropertyValue[]{PropertyFactory.visibility((String)(isVisible ? "visible" : "none"))});
        }
    }

    private void resetSource(GeoJsonSource source) {
        source.setGeoJson(FeatureCollection.fromFeatures((Feature[])new Feature[0]));
    }
}

