/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.map;

import android.content.Context;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.services.android.navigation.ui.v5.camera.OnTrackingModeChangedListener;
import com.mapbox.services.android.navigation.ui.v5.camera.OnTrackingModeTransitionListener;
import com.mapbox.services.android.navigation.ui.v5.map.FpsDelegateProgressChangeListener;
import com.mapbox.services.android.navigation.ui.v5.map.MapBatteryMonitor;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigation;
import com.mapbox.services.android.navigation.v5.routeprogress.ProgressChangeListener;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteLegProgress;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;

class MapFpsDelegate
implements OnTrackingModeChangedListener,
OnTrackingModeTransitionListener {
    static final int DEFAULT_MAX_FPS_THRESHOLD = 20;
    private static final double VALID_DURATION_IN_SECONDS_UNTIL_NEXT_MANEUVER = 7.0;
    private static final double VALID_DURATION_IN_SECONDS_SINCE_PREVIOUS_MANEUVER = 5.0;
    private static final int DEVICE_MAX_FPS = Integer.MAX_VALUE;
    private static final int LOW_POWER_MAX_FPS = 30;
    private final MapView mapView;
    private final MapBatteryMonitor batteryMonitor;
    private final ProgressChangeListener fpsProgressListener = new FpsDelegateProgressChangeListener(this);
    private MapboxNavigation navigation;
    private int maxFpsThreshold = 20;
    private boolean isTracking = true;
    private boolean isEnabled = true;

    MapFpsDelegate(MapView mapView, MapBatteryMonitor batteryMonitor) {
        this.mapView = mapView;
        this.batteryMonitor = batteryMonitor;
    }

    @Override
    public void onTrackingModeChanged(int trackingMode) {
        int trackingModeNone = 2;
        if (trackingMode == trackingModeNone) {
            this.updateCameraTracking(trackingModeNone);
        }
    }

    @Override
    public void onTransitionFinished(int trackingMode) {
        this.updateCameraTracking(trackingMode);
    }

    @Override
    public void onTransitionCancelled(int trackingMode) {
        this.updateCameraTracking(trackingMode);
    }

    void addProgressChangeListener(MapboxNavigation navigation) {
        this.navigation = navigation;
        navigation.addProgressChangeListener(this.fpsProgressListener);
    }

    void onStart() {
        if (this.navigation != null) {
            this.navigation.addProgressChangeListener(this.fpsProgressListener);
        }
    }

    void onStop() {
        if (this.navigation != null) {
            this.navigation.removeProgressChangeListener(this.fpsProgressListener);
        }
    }

    void updateEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        this.resetMaxFps(!isEnabled);
    }

    void updateMaxFpsThreshold(int maxFps) {
        this.maxFpsThreshold = maxFps;
    }

    void adjustFpsFor(RouteProgress routeProgress) {
        if (!this.isEnabled || !this.isTracking) {
            return;
        }
        int maxFps = this.determineMaxFpsFrom(routeProgress, this.mapView.getContext());
        this.mapView.setMaximumFps(maxFps);
    }

    private void updateCameraTracking(int trackingMode) {
        this.isTracking = trackingMode != 2;
        this.resetMaxFps(!this.isTracking);
    }

    private void resetMaxFps(boolean shouldReset) {
        if (shouldReset) {
            this.mapView.setMaximumFps(Integer.MAX_VALUE);
        }
    }

    private int determineMaxFpsFrom(RouteProgress routeProgress, Context context) {
        boolean isPluggedIn = this.batteryMonitor.isPluggedIn(context);
        RouteLegProgress routeLegProgress = routeProgress.currentLegProgress();
        if (isPluggedIn) {
            return 30;
        }
        if (this.validLowFpsManeuver(routeLegProgress) || this.validLowFpsDuration(routeLegProgress)) {
            return this.maxFpsThreshold;
        }
        return 30;
    }

    private boolean validLowFpsManeuver(RouteLegProgress routeLegProgress) {
        String maneuverModifier = routeLegProgress.currentStep().maneuver().modifier();
        return maneuverModifier != null && (maneuverModifier.equals("straight") || maneuverModifier.equals("slight left") || maneuverModifier.equals("slight right"));
    }

    private boolean validLowFpsDuration(RouteLegProgress routeLegProgress) {
        double expectedStepDuration = routeLegProgress.currentStep().duration();
        double durationUntilNextManeuver = routeLegProgress.currentStepProgress().durationRemaining();
        double durationSincePreviousManeuver = expectedStepDuration - durationUntilNextManeuver;
        return durationUntilNextManeuver > 7.0 && durationSincePreviousManeuver > 5.0;
    }
}

