/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.instruction.turnlane;

class TurnLaneViewData {
    static final String DRAW_LANE_SLIGHT_RIGHT = "draw_lane_slight_right";
    static final String DRAW_LANE_RIGHT = "draw_lane_right";
    static final String DRAW_LANE_STRAIGHT = "draw_lane_straight";
    static final String DRAW_LANE_UTURN = "draw_lane_uturn";
    static final String DRAW_LANE_RIGHT_ONLY = "draw_lane_right_only";
    static final String DRAW_LANE_STRAIGHT_ONLY = "draw_lane_straight_only";
    private boolean shouldFlip;
    private String drawMethod;

    TurnLaneViewData(String laneIndications, String maneuverModifier) {
        this.buildDrawData(laneIndications, maneuverModifier);
    }

    boolean shouldBeFlipped() {
        return this.shouldFlip;
    }

    String getDrawMethod() {
        return this.drawMethod;
    }

    private void buildDrawData(String laneIndications, String maneuverModifier) {
        if (laneIndications.contentEquals("uturn")) {
            this.drawMethod = DRAW_LANE_UTURN;
            this.shouldFlip = true;
            return;
        }
        if (laneIndications.contentEquals("straight")) {
            this.drawMethod = DRAW_LANE_STRAIGHT;
            return;
        }
        if (laneIndications.contentEquals("right")) {
            this.drawMethod = DRAW_LANE_RIGHT;
            return;
        }
        if (laneIndications.contentEquals("left")) {
            this.drawMethod = DRAW_LANE_RIGHT;
            this.shouldFlip = true;
            return;
        }
        if (laneIndications.contentEquals("slight right")) {
            this.drawMethod = DRAW_LANE_SLIGHT_RIGHT;
            return;
        }
        if (laneIndications.contentEquals("slight left")) {
            this.drawMethod = DRAW_LANE_SLIGHT_RIGHT;
            this.shouldFlip = true;
            return;
        }
        if (this.isStraightPlusIndication(laneIndications, "right")) {
            this.setDrawMethodWithModifier(maneuverModifier);
        } else if (this.isStraightPlusIndication(laneIndications, "left")) {
            this.setDrawMethodWithModifier(maneuverModifier);
            this.shouldFlip = true;
        }
    }

    private void setDrawMethodWithModifier(String maneuverModifier) {
        this.drawMethod = maneuverModifier.contains("right") ? DRAW_LANE_RIGHT_ONLY : (maneuverModifier.contains("straight") ? DRAW_LANE_STRAIGHT_ONLY : DRAW_LANE_RIGHT_ONLY);
    }

    private boolean isStraightPlusIndication(String laneIndications, String turnLaneIndication) {
        return laneIndications.contains("straight") && laneIndications.contains(turnLaneIndication);
    }
}

