/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.instruction;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.SpannableString;
import android.text.style.ImageSpan;
import android.view.View;
import android.widget.TextView;

class TextViewUtils {
    TextViewUtils() {
    }

    boolean textFits(TextView textView, String text) {
        Paint paint = new Paint((Paint)textView.getPaint());
        float width = paint.measureText(text);
        return width < (float)textView.getWidth();
    }

    Drawable createDrawable(TextView textView, Bitmap bitmap) {
        BitmapDrawable drawable2 = new BitmapDrawable(textView.getContext().getResources(), bitmap);
        int bottom = textView.getLineHeight();
        int right = bottom * bitmap.getWidth() / bitmap.getHeight();
        drawable2.setBounds(0, 0, right, bottom);
        return drawable2;
    }

    void setImageSpan(TextView textView, View view, int start, int end) {
        Bitmap bitmap = this.createBitmapFromView(view);
        this.setImageSpan(textView, bitmap, start, end);
    }

    private void setImageSpan(TextView textView, Bitmap bitmap, int start, int end) {
        Drawable drawable2 = this.createDrawable(textView, bitmap);
        this.setImageSpan(textView, drawable2, start, end);
    }

    private void setImageSpan(TextView textView, Drawable drawable2, int start, int end) {
        SpannableString instructionSpannable = new SpannableString(textView.getText());
        instructionSpannable.setSpan((Object)new ImageSpan(drawable2), start, end, 33);
        textView.setText((CharSequence)instructionSpannable);
    }

    private Bitmap createBitmapFromView(View view) {
        int measureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        view.measure(measureSpec, measureSpec);
        int measuredWidth = view.getMeasuredWidth();
        int measuredHeight = view.getMeasuredHeight();
        view.layout(0, 0, measuredWidth, measuredHeight);
        Bitmap bitmap = Bitmap.createBitmap((int)measuredWidth, (int)measuredHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.eraseColor(0);
        Canvas canvas = new Canvas(bitmap);
        view.draw(canvas);
        return bitmap;
    }
}

