/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.instruction;

import android.content.Context;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.view.View;
import com.mapbox.services.android.navigation.ui.v5.NavigationViewModel;
import com.mapbox.services.android.navigation.ui.v5.R;
import com.mapbox.services.android.navigation.ui.v5.alert.AlertView;
import com.mapbox.services.android.navigation.ui.v5.feedback.FeedbackBottomSheet;
import com.mapbox.services.android.navigation.ui.v5.feedback.FeedbackBottomSheetListener;
import com.mapbox.services.android.navigation.ui.v5.feedback.FeedbackItem;
import timber.log.Timber;

public class NavigationAlertView
extends AlertView
implements FeedbackBottomSheetListener {
    private static final long THREE_SECOND_DELAY_IN_MILLIS = 3000L;
    private NavigationViewModel navigationViewModel;
    private boolean isEnabled = true;

    public NavigationAlertView(Context context) {
        this(context, null);
    }

    public NavigationAlertView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public NavigationAlertView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void subscribe(NavigationViewModel navigationViewModel) {
        this.navigationViewModel = navigationViewModel;
    }

    public void showFeedbackSubmitted() {
        if (!this.isEnabled) {
            return;
        }
        this.show(this.getContext().getString(R.string.feedback_submitted), 3000L, false);
    }

    public void showReportProblem() {
        if (!this.isEnabled) {
            return;
        }
        Handler handler = new Handler();
        handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                NavigationAlertView.this.show(NavigationAlertView.this.getContext().getString(R.string.report_problem), 10000L, true);
            }
        }, 3000L);
    }

    public void showFeedbackBottomSheet() {
        if (!this.isEnabled) {
            return;
        }
        FragmentManager fragmentManager = this.obtainSupportFragmentManager();
        if (fragmentManager != null) {
            long duration = 10000L;
            FeedbackBottomSheet.newInstance(this, duration).show(fragmentManager, FeedbackBottomSheet.TAG);
        }
    }

    public void updateEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    @Override
    public void onFeedbackSelected(FeedbackItem feedbackItem) {
        if (this.navigationViewModel == null) {
            return;
        }
        this.navigationViewModel.updateFeedback(feedbackItem);
        this.showFeedbackSubmitted();
    }

    @Override
    public void onFeedbackDismissed() {
        if (this.navigationViewModel == null) {
            return;
        }
        this.navigationViewModel.cancelFeedback();
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (NavigationAlertView.this.navigationViewModel != null && NavigationAlertView.this.isShowingReportProblem()) {
                    NavigationAlertView.this.navigationViewModel.recordFeedback("reroute");
                    NavigationAlertView.this.showFeedbackBottomSheet();
                }
                NavigationAlertView.this.hide();
            }
        });
    }

    @Nullable
    private FragmentManager obtainSupportFragmentManager() {
        try {
            return ((FragmentActivity)this.getContext()).getSupportFragmentManager();
        }
        catch (ClassCastException exception) {
            Timber.e((Throwable)exception);
            return null;
        }
    }

    private boolean isShowingReportProblem() {
        return this.getAlertText().equals(this.getContext().getString(R.string.report_problem));
    }
}

