/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.instruction;

import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.Observer;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.constraint.ConstraintLayout;
import android.support.constraint.ConstraintSet;
import android.support.transition.AutoTransition;
import android.support.transition.Transition;
import android.support.transition.TransitionManager;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.mapbox.api.directions.v5.models.BannerComponents;
import com.mapbox.api.directions.v5.models.BannerInstructions;
import com.mapbox.api.directions.v5.models.BannerText;
import com.mapbox.api.directions.v5.models.LegStep;
import com.mapbox.services.android.navigation.ui.v5.FeedbackButton;
import com.mapbox.services.android.navigation.ui.v5.NavigationButton;
import com.mapbox.services.android.navigation.ui.v5.NavigationViewModel;
import com.mapbox.services.android.navigation.ui.v5.R;
import com.mapbox.services.android.navigation.ui.v5.SoundButton;
import com.mapbox.services.android.navigation.ui.v5.ThemeSwitcher;
import com.mapbox.services.android.navigation.ui.v5.feedback.FeedbackBottomSheet;
import com.mapbox.services.android.navigation.ui.v5.feedback.FeedbackBottomSheetListener;
import com.mapbox.services.android.navigation.ui.v5.feedback.FeedbackItem;
import com.mapbox.services.android.navigation.ui.v5.instruction.BannerInstructionModel;
import com.mapbox.services.android.navigation.ui.v5.instruction.ImageCreator;
import com.mapbox.services.android.navigation.ui.v5.instruction.InstructionListTransitionListener;
import com.mapbox.services.android.navigation.ui.v5.instruction.InstructionLoader;
import com.mapbox.services.android.navigation.ui.v5.instruction.InstructionModel;
import com.mapbox.services.android.navigation.ui.v5.instruction.NavigationAlertView;
import com.mapbox.services.android.navigation.ui.v5.instruction.maneuver.ManeuverView;
import com.mapbox.services.android.navigation.ui.v5.instruction.turnlane.TurnLaneAdapter;
import com.mapbox.services.android.navigation.ui.v5.listeners.InstructionListListener;
import com.mapbox.services.android.navigation.ui.v5.summary.list.InstructionListAdapter;
import com.mapbox.services.android.navigation.v5.milestone.BannerInstructionMilestone;
import com.mapbox.services.android.navigation.v5.milestone.Milestone;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import com.mapbox.services.android.navigation.v5.utils.DistanceFormatter;
import com.mapbox.services.android.navigation.v5.utils.LocaleUtils;
import com.mapbox.services.android.navigation.v5.utils.RouteUtils;
import timber.log.Timber;

public class InstructionView
extends RelativeLayout
implements FeedbackBottomSheetListener {
    private static final String COMPONENT_TYPE_LANE = "lane";
    private ManeuverView upcomingManeuverView;
    private TextView upcomingDistanceText;
    private TextView upcomingPrimaryText;
    private TextView upcomingSecondaryText;
    private ManeuverView subManeuverView;
    private TextView subStepText;
    private NavigationAlertView alertView;
    private View rerouteLayout;
    private View turnLaneLayout;
    private View subStepLayout;
    private RecyclerView rvTurnLanes;
    private RecyclerView rvInstructions;
    private TurnLaneAdapter turnLaneAdapter;
    private ConstraintLayout instructionLayout;
    private LinearLayout instructionLayoutText;
    private View instructionListLayout;
    private InstructionListAdapter instructionListAdapter;
    private Animation rerouteSlideUpTop;
    private Animation rerouteSlideDownTop;
    private LegStep currentStep;
    private NavigationViewModel navigationViewModel;
    private InstructionListListener instructionListListener;
    private DistanceFormatter distanceFormatter;
    private boolean isRerouting;
    private SoundButton soundButton;
    private FeedbackButton feedbackButton;

    public InstructionView(Context context) {
        this(context, null);
    }

    public InstructionView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public InstructionView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize();
    }

    public void setInstructionListListener(InstructionListListener instructionListListener) {
        this.instructionListListener = instructionListListener;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.bind();
        this.initializeBackground();
        this.initializeTurnLaneRecyclerView();
        this.initializeInstructionListRecyclerView();
        this.initializeAnimations();
        this.initializeStepListClickListener();
        this.initializeButtons();
        ImageCreator.getInstance().initialize(this.getContext());
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.addBottomSheetListener();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.cancelDelayedTransition();
    }

    @Override
    public void onFeedbackSelected(FeedbackItem feedbackItem) {
        this.navigationViewModel.updateFeedback(feedbackItem);
        this.alertView.showFeedbackSubmitted();
    }

    @Override
    public void onFeedbackDismissed() {
        this.navigationViewModel.cancelFeedback();
    }

    public void subscribe(NavigationViewModel navigationViewModel) {
        this.navigationViewModel = navigationViewModel;
        LifecycleOwner owner = (LifecycleOwner)this.getContext();
        navigationViewModel.instructionModel.observe(owner, (Observer)new Observer<InstructionModel>(){

            public void onChanged(@Nullable InstructionModel model) {
                if (model != null) {
                    InstructionView.this.updateDataFromInstruction(model);
                }
            }
        });
        navigationViewModel.bannerInstructionModel.observe(owner, (Observer)new Observer<BannerInstructionModel>(){

            public void onChanged(@Nullable BannerInstructionModel model) {
                if (model != null) {
                    InstructionView.this.updateManeuverView(model.retrievePrimaryManeuverType(), model.retrieveSecondaryManeuverModifier(), model.retrievePrimaryRoundaboutAngle());
                    InstructionView.this.updateDataFromBannerText(model.retrievePrimaryBannerText(), model.retrieveSecondaryBannerText());
                    InstructionView.this.updateSubStep(model.retrieveSubBannerText(), model.retrievePrimaryManeuverType());
                }
            }
        });
        navigationViewModel.isOffRoute.observe(owner, (Observer)new Observer<Boolean>(){

            public void onChanged(@Nullable Boolean isOffRoute) {
                if (isOffRoute != null) {
                    if (isOffRoute.booleanValue()) {
                        InstructionView.this.showRerouteState();
                    } else if (InstructionView.this.isRerouting) {
                        InstructionView.this.hideRerouteState();
                        InstructionView.this.alertView.showReportProblem();
                    }
                    InstructionView.this.isRerouting = isOffRoute;
                }
            }
        });
        this.subscribeAlertView();
        this.initializeButtonListeners();
        this.showButtons();
    }

    public void updateDistanceWith(RouteProgress routeProgress) {
        if (routeProgress != null && !this.isRerouting) {
            InstructionModel model = new InstructionModel(this.distanceFormatter, routeProgress);
            this.updateDataFromInstruction(model);
        }
    }

    public void updateBannerInstructionsWith(Milestone milestone) {
        if (milestone instanceof BannerInstructionMilestone) {
            BannerInstructions instructions = ((BannerInstructionMilestone)milestone).getBannerInstructions();
            if (instructions == null || instructions.primary() == null) {
                return;
            }
            BannerText primary = instructions.primary();
            String primaryManeuverModifier = primary.modifier();
            this.updateManeuverView(primary.type(), primaryManeuverModifier, primary.degrees());
            this.updateDataFromBannerText(primary, instructions.secondary());
            this.updateSubStep(instructions.sub(), primaryManeuverModifier);
        }
    }

    public void showFeedbackBottomSheet() {
        FragmentManager fragmentManager = this.obtainSupportFragmentManager();
        if (fragmentManager != null) {
            long duration = 10000L;
            FeedbackBottomSheet.newInstance(this, duration).show(fragmentManager, FeedbackBottomSheet.TAG);
        }
    }

    public void showRerouteState() {
        if (this.rerouteLayout.getVisibility() == 4) {
            this.rerouteLayout.startAnimation(this.rerouteSlideDownTop);
            this.rerouteLayout.setVisibility(0);
        }
    }

    public void hideRerouteState() {
        if (this.rerouteLayout.getVisibility() == 0) {
            this.rerouteLayout.startAnimation(this.rerouteSlideUpTop);
            this.rerouteLayout.setVisibility(4);
        }
    }

    public boolean isShowingInstructionList() {
        return this.instructionListLayout.getVisibility() == 0;
    }

    public void hideInstructionList() {
        this.rvInstructions.stopScroll();
        this.beginDelayedTransition();
        if (this.isLandscape()) {
            this.updateLandscapeConstraintsTo(R.layout.instruction_layout);
        }
        this.instructionListLayout.setVisibility(8);
        this.onInstructionListVisibilityChanged(false);
    }

    private boolean isLandscape() {
        return this.getContext().getResources().getConfiguration().orientation == 2;
    }

    public void showInstructionList() {
        this.onInstructionListVisibilityChanged(true);
        this.instructionLayout.requestFocus();
        this.beginDelayedListTransition();
        if (this.isLandscape()) {
            this.updateLandscapeConstraintsTo(R.layout.instruction_layout_alt);
        }
        this.instructionListLayout.setVisibility(0);
    }

    public boolean handleBackPressed() {
        if (this.isShowingInstructionList()) {
            this.hideInstructionList();
            return true;
        }
        return false;
    }

    public void setDistanceFormatter(DistanceFormatter distanceFormatter) {
        if (distanceFormatter != null && !distanceFormatter.equals(this.distanceFormatter)) {
            this.distanceFormatter = distanceFormatter;
            this.instructionListAdapter.updateDistanceFormatter(distanceFormatter);
        }
    }

    public NavigationButton retrieveSoundButton() {
        return this.soundButton;
    }

    public NavigationButton retrieveFeedbackButton() {
        return this.feedbackButton;
    }

    public NavigationAlertView retrieveAlertView() {
        return this.alertView;
    }

    private void initialize() {
        LocaleUtils localeUtils = new LocaleUtils();
        String language = localeUtils.inferDeviceLanguage(this.getContext());
        String unitType = localeUtils.getUnitTypeForDeviceLocale(this.getContext());
        int roundingIncrement = 50;
        this.distanceFormatter = new DistanceFormatter(this.getContext(), language, unitType, roundingIncrement);
        InstructionView.inflate((Context)this.getContext(), (int)R.layout.instruction_view_layout, (ViewGroup)this);
    }

    private void bind() {
        this.upcomingManeuverView = (ManeuverView)this.findViewById(R.id.maneuverView);
        this.upcomingDistanceText = (TextView)this.findViewById(R.id.stepDistanceText);
        this.upcomingPrimaryText = (TextView)this.findViewById(R.id.stepPrimaryText);
        this.upcomingSecondaryText = (TextView)this.findViewById(R.id.stepSecondaryText);
        this.subManeuverView = (ManeuverView)this.findViewById(R.id.subManeuverView);
        this.subStepText = (TextView)this.findViewById(R.id.subStepText);
        this.alertView = (NavigationAlertView)this.findViewById(R.id.alertView);
        this.rerouteLayout = this.findViewById(R.id.rerouteLayout);
        this.turnLaneLayout = this.findViewById(R.id.turnLaneLayout);
        this.subStepLayout = this.findViewById(R.id.subStepLayout);
        this.rvTurnLanes = (RecyclerView)this.findViewById(R.id.rvTurnLanes);
        this.instructionLayout = (ConstraintLayout)this.findViewById(R.id.instructionLayout);
        this.instructionLayoutText = (LinearLayout)this.findViewById(R.id.instructionLayoutText);
        this.instructionListLayout = this.findViewById(R.id.instructionListLayout);
        this.rvInstructions = (RecyclerView)this.findViewById(R.id.rvInstructions);
        this.soundButton = (SoundButton)this.findViewById(R.id.soundLayout);
        this.feedbackButton = (FeedbackButton)this.findViewById(R.id.feedbackLayout);
    }

    private void initializeBackground() {
        if (Build.VERSION.SDK_INT < 21) {
            int navigationViewBannerBackgroundColor = ThemeSwitcher.retrieveThemeColor(this.getContext(), R.attr.navigationViewBannerBackground);
            int navigationViewListBackgroundColor = ThemeSwitcher.retrieveThemeColor(this.getContext(), R.attr.navigationViewListBackground);
            if (this.isLandscape()) {
                View instructionLayoutManeuver = this.findViewById(R.id.instructionManeuverLayout);
                Drawable maneuverBackground = DrawableCompat.wrap((Drawable)instructionLayoutManeuver.getBackground()).mutate();
                DrawableCompat.setTint((Drawable)maneuverBackground, (int)navigationViewBannerBackgroundColor);
                View subStepLayout = this.findViewById(R.id.subStepLayout);
                Drawable subStepBackground = DrawableCompat.wrap((Drawable)subStepLayout.getBackground()).mutate();
                DrawableCompat.setTint((Drawable)subStepBackground, (int)navigationViewListBackgroundColor);
                View turnLaneLayout = this.findViewById(R.id.turnLaneLayout);
                Drawable turnLaneBackground = DrawableCompat.wrap((Drawable)turnLaneLayout.getBackground()).mutate();
                DrawableCompat.setTint((Drawable)turnLaneBackground, (int)navigationViewListBackgroundColor);
            }
        }
    }

    private void initializeTurnLaneRecyclerView() {
        this.turnLaneAdapter = new TurnLaneAdapter();
        this.rvTurnLanes.setAdapter((RecyclerView.Adapter)this.turnLaneAdapter);
        this.rvTurnLanes.setHasFixedSize(true);
        this.rvTurnLanes.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext(), 0, false));
    }

    private void initializeInstructionListRecyclerView() {
        RouteUtils routeUtils = new RouteUtils();
        this.instructionListAdapter = new InstructionListAdapter(routeUtils, this.distanceFormatter);
        this.rvInstructions.setAdapter((RecyclerView.Adapter)this.instructionListAdapter);
        this.rvInstructions.setHasFixedSize(true);
        this.rvInstructions.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
    }

    private void initializeAnimations() {
        Context context = this.getContext();
        this.rerouteSlideDownTop = AnimationUtils.loadAnimation((Context)context, (int)R.anim.slide_down_top);
        this.rerouteSlideUpTop = AnimationUtils.loadAnimation((Context)context, (int)R.anim.slide_up_top);
    }

    private void onInstructionListVisibilityChanged(boolean visible) {
        if (this.instructionListListener != null) {
            this.instructionListListener.onInstructionListVisibilityChanged(visible);
        }
    }

    private void addBottomSheetListener() {
        String tag;
        FeedbackBottomSheet feedbackBottomSheet;
        FragmentManager fragmentManager = this.obtainSupportFragmentManager();
        if (fragmentManager != null && (feedbackBottomSheet = (FeedbackBottomSheet)fragmentManager.findFragmentByTag(tag = FeedbackBottomSheet.TAG)) != null) {
            feedbackBottomSheet.setFeedbackBottomSheetListener(this);
        }
    }

    private void subscribeAlertView() {
        this.alertView.subscribe(this.navigationViewModel);
    }

    private void initializeButtonListeners() {
        this.feedbackButton.addOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                InstructionView.this.navigationViewModel.recordFeedback("user");
                InstructionView.this.showFeedbackBottomSheet();
            }
        });
        this.soundButton.addOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                InstructionView.this.navigationViewModel.setMuted(InstructionView.this.soundButton.toggleMute());
            }
        });
    }

    private void showButtons() {
        this.feedbackButton.show();
        this.soundButton.show();
    }

    private void initializeStepListClickListener() {
        if (this.isLandscape()) {
            this.initializeLandscapeListListener();
        } else {
            this.initializePortraitListListener();
        }
    }

    private void initializeButtons() {
        this.feedbackButton.hide();
        this.soundButton.hide();
    }

    private void initializePortraitListListener() {
        this.instructionLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View instructionView) {
                boolean instructionsVisible;
                boolean bl = instructionsVisible = InstructionView.this.instructionListLayout.getVisibility() == 0;
                if (!instructionsVisible) {
                    InstructionView.this.showInstructionList();
                } else {
                    InstructionView.this.hideInstructionList();
                }
            }
        });
    }

    private void initializeLandscapeListListener() {
        this.instructionLayoutText.setOnClickListener(new View.OnClickListener(){

            public void onClick(View instructionLayoutText) {
                boolean instructionsVisible;
                boolean bl = instructionsVisible = InstructionView.this.instructionListLayout.getVisibility() == 0;
                if (!instructionsVisible) {
                    InstructionView.this.showInstructionList();
                } else {
                    InstructionView.this.hideInstructionList();
                }
            }
        });
    }

    private boolean newDistanceText(InstructionModel model) {
        return !this.upcomingDistanceText.getText().toString().isEmpty() && !TextUtils.isEmpty((CharSequence)model.retrieveStepDistanceRemaining()) && !this.upcomingDistanceText.getText().toString().contentEquals(model.retrieveStepDistanceRemaining().toString());
    }

    private void distanceText(InstructionModel model) {
        this.upcomingDistanceText.setText((CharSequence)model.retrieveStepDistanceRemaining());
    }

    private InstructionLoader createInstructionLoader(TextView textView, BannerText bannerText) {
        if (this.hasComponents(bannerText)) {
            return new InstructionLoader(textView, bannerText);
        }
        return null;
    }

    private boolean hasComponents(BannerText bannerText) {
        return bannerText != null && bannerText.components() != null && !bannerText.components().isEmpty();
    }

    private boolean newStep(RouteProgress routeProgress) {
        boolean newStep = this.currentStep == null || !this.currentStep.equals(routeProgress.currentLegProgress().currentStep());
        this.currentStep = routeProgress.currentLegProgress().currentStep();
        return newStep;
    }

    private void updateSubStep(BannerText subText, String primaryManeuverModifier) {
        if (this.shouldShowSubStep(subText)) {
            InstructionLoader instructionLoader;
            String maneuverType = subText.type();
            String maneuverModifier = subText.modifier();
            this.subManeuverView.setManeuverTypeAndModifier(maneuverType, maneuverModifier);
            Double roundaboutAngle = subText.degrees();
            if (roundaboutAngle != null) {
                this.subManeuverView.setRoundaboutAngle(roundaboutAngle.floatValue());
            }
            if ((instructionLoader = this.createInstructionLoader(this.subStepText, subText)) != null) {
                instructionLoader.loadInstruction();
            }
            this.showSubLayout();
            return;
        }
        this.hideSubLayout();
        if (this.shouldShowTurnLanes(subText, primaryManeuverModifier)) {
            this.turnLaneAdapter.addTurnLanes(subText.components(), primaryManeuverModifier);
            this.showTurnLanes();
        } else {
            this.hideTurnLanes();
        }
    }

    private boolean shouldShowSubStep(@Nullable BannerText subText) {
        return subText != null && subText.type() != null && !subText.type().contains(COMPONENT_TYPE_LANE);
    }

    private void showSubLayout() {
        if (this.subStepLayout.getVisibility() != 0) {
            this.beginDelayedTransition();
            this.subStepLayout.setVisibility(0);
        }
    }

    private void hideSubLayout() {
        if (this.subStepLayout.getVisibility() == 0) {
            this.beginDelayedTransition();
            this.subStepLayout.setVisibility(8);
        }
    }

    private boolean shouldShowTurnLanes(BannerText subText, String maneuverModifier) {
        if (!this.hasComponents(subText) || TextUtils.isEmpty((CharSequence)maneuverModifier)) {
            return false;
        }
        for (BannerComponents components : subText.components()) {
            if (!components.type().equals(COMPONENT_TYPE_LANE)) continue;
            return true;
        }
        return false;
    }

    private void showTurnLanes() {
        if (this.turnLaneLayout.getVisibility() == 8) {
            this.beginDelayedTransition();
            this.turnLaneLayout.setVisibility(0);
        }
    }

    private void hideTurnLanes() {
        if (this.turnLaneLayout.getVisibility() == 0) {
            this.beginDelayedTransition();
            this.turnLaneLayout.setVisibility(8);
        }
    }

    @Nullable
    private FragmentManager obtainSupportFragmentManager() {
        try {
            return ((FragmentActivity)this.getContext()).getSupportFragmentManager();
        }
        catch (ClassCastException exception) {
            Timber.e((Throwable)exception);
            return null;
        }
    }

    private void adjustBannerTextVerticalBias(float percentBias) {
        if (!this.isLandscape()) {
            ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)this.instructionLayoutText.getLayoutParams();
            params.verticalBias = percentBias;
            this.instructionLayoutText.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    private void beginDelayedTransition() {
        TransitionManager.beginDelayedTransition((ViewGroup)this);
    }

    private void beginDelayedListTransition() {
        AutoTransition transition = new AutoTransition();
        transition.addListener((Transition.TransitionListener)new InstructionListTransitionListener(this.rvInstructions, this.instructionListAdapter));
        TransitionManager.beginDelayedTransition((ViewGroup)this, (Transition)transition);
    }

    private void cancelDelayedTransition() {
        if (Build.VERSION.SDK_INT >= 19) {
            this.clearAnimation();
        }
    }

    private void updateDataFromInstruction(InstructionModel model) {
        this.updateDistanceText(model);
        this.updateInstructionList(model);
        if (this.newStep(model.retrieveProgress())) {
            LegStep upComingStep = model.retrieveProgress().currentLegProgress().upComingStep();
            ImageCreator.getInstance().prefetchImageCache(upComingStep);
        }
    }

    private void updateDataFromBannerText(@NonNull BannerText primaryBannerText, BannerText secondaryBannerText) {
        if (secondaryBannerText == null) {
            this.loadPrimary(primaryBannerText);
            return;
        }
        this.loadPrimaryAndSecondary(primaryBannerText, secondaryBannerText);
    }

    private void loadPrimary(BannerText primaryBannerText) {
        this.upcomingPrimaryText.setMaxLines(2);
        this.upcomingSecondaryText.setVisibility(8);
        this.adjustBannerTextVerticalBias(0.5f);
        this.loadTextWith(primaryBannerText, this.upcomingPrimaryText);
    }

    private void loadPrimaryAndSecondary(BannerText primaryBannerText, BannerText secondaryBannerText) {
        this.upcomingPrimaryText.setMaxLines(1);
        this.upcomingSecondaryText.setVisibility(0);
        this.adjustBannerTextVerticalBias(0.65f);
        this.loadTextWith(primaryBannerText, this.upcomingPrimaryText);
        this.loadTextWith(secondaryBannerText, this.upcomingSecondaryText);
    }

    private void loadTextWith(BannerText bannerText, TextView textView) {
        InstructionLoader instructionLoader = this.createInstructionLoader(textView, bannerText);
        if (instructionLoader != null) {
            instructionLoader.loadInstruction();
        }
    }

    private void updateManeuverView(String maneuverViewType, String maneuverViewModifier, @Nullable Double roundaboutAngle) {
        this.upcomingManeuverView.setManeuverTypeAndModifier(maneuverViewType, maneuverViewModifier);
        if (roundaboutAngle != null) {
            this.upcomingManeuverView.setRoundaboutAngle(roundaboutAngle.floatValue());
        }
    }

    private void updateDistanceText(InstructionModel model) {
        if (this.newDistanceText(model)) {
            this.distanceText(model);
        } else if (this.upcomingDistanceText.getText().toString().isEmpty()) {
            this.distanceText(model);
        }
    }

    private void updateLandscapeConstraintsTo(int layoutRes) {
        ConstraintSet collapsed = new ConstraintSet();
        collapsed.clone(this.getContext(), layoutRes);
        collapsed.applyTo(this.instructionLayout);
    }

    private void updateInstructionList(InstructionModel model) {
        RouteProgress routeProgress = model.retrieveProgress();
        boolean isListShowing = this.instructionListLayout.getVisibility() == 0;
        this.rvInstructions.stopScroll();
        this.instructionListAdapter.updateBannerListWith(routeProgress, isListShowing);
    }
}

