/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5;

import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.content.res.Resources;
import android.location.Location;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.BottomSheetBehavior;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.app.FragmentActivity;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.api.directions.v5.models.RouteOptions;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.OnMapReadyCallback;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.services.android.navigation.ui.v5.CancelBtnClickListener;
import com.mapbox.services.android.navigation.ui.v5.NavigationButton;
import com.mapbox.services.android.navigation.ui.v5.NavigationContract;
import com.mapbox.services.android.navigation.ui.v5.NavigationInstructionListListener;
import com.mapbox.services.android.navigation.ui.v5.NavigationOnCameraTrackingChangedListener;
import com.mapbox.services.android.navigation.ui.v5.NavigationPresenter;
import com.mapbox.services.android.navigation.ui.v5.NavigationSnapshotReadyCallback;
import com.mapbox.services.android.navigation.ui.v5.NavigationViewEventDispatcher;
import com.mapbox.services.android.navigation.ui.v5.NavigationViewInstanceState;
import com.mapbox.services.android.navigation.ui.v5.NavigationViewModel;
import com.mapbox.services.android.navigation.ui.v5.NavigationViewOptions;
import com.mapbox.services.android.navigation.ui.v5.NavigationViewSubscriber;
import com.mapbox.services.android.navigation.ui.v5.NavigationViewWayNameListener;
import com.mapbox.services.android.navigation.ui.v5.OnNavigationReadyCallback;
import com.mapbox.services.android.navigation.ui.v5.R;
import com.mapbox.services.android.navigation.ui.v5.RecenterBtnClickListener;
import com.mapbox.services.android.navigation.ui.v5.RecenterButton;
import com.mapbox.services.android.navigation.ui.v5.RouteOverviewBtnClickListener;
import com.mapbox.services.android.navigation.ui.v5.SoundButton;
import com.mapbox.services.android.navigation.ui.v5.SummaryBottomSheetCallback;
import com.mapbox.services.android.navigation.ui.v5.ThemeSwitcher;
import com.mapbox.services.android.navigation.ui.v5.instruction.ImageCreator;
import com.mapbox.services.android.navigation.ui.v5.instruction.InstructionView;
import com.mapbox.services.android.navigation.ui.v5.instruction.NavigationAlertView;
import com.mapbox.services.android.navigation.ui.v5.map.NavigationMapboxMap;
import com.mapbox.services.android.navigation.ui.v5.map.NavigationMapboxMapInstanceState;
import com.mapbox.services.android.navigation.ui.v5.map.WayNameView;
import com.mapbox.services.android.navigation.ui.v5.summary.SummaryBottomSheet;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigation;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigationOptions;
import com.mapbox.services.android.navigation.v5.utils.DistanceFormatter;
import com.mapbox.services.android.navigation.v5.utils.LocaleUtils;

public class NavigationView
extends CoordinatorLayout
implements LifecycleObserver,
OnMapReadyCallback,
NavigationContract.View {
    private static final String MAP_INSTANCE_STATE_KEY = "navgation_mapbox_map_instance_state";
    private static final int INVALID_STATE = 0;
    private MapView mapView;
    private InstructionView instructionView;
    private SummaryBottomSheet summaryBottomSheet;
    private BottomSheetBehavior summaryBehavior;
    private ImageButton cancelBtn;
    private RecenterButton recenterBtn;
    private WayNameView wayNameView;
    private ImageButton routeOverviewBtn;
    private NavigationPresenter navigationPresenter;
    private NavigationViewEventDispatcher navigationViewEventDispatcher;
    private NavigationViewModel navigationViewModel;
    private NavigationMapboxMap navigationMap;
    private OnNavigationReadyCallback onNavigationReadyCallback;
    private NavigationOnCameraTrackingChangedListener onTrackingChangedListener;
    private NavigationMapboxMapInstanceState mapInstanceState;
    private CameraPosition initialMapCameraPosition;
    private boolean isMapInitialized;
    private boolean isSubscribed;

    public NavigationView(Context context) {
        this(context, null);
    }

    public NavigationView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public NavigationView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        ThemeSwitcher.setTheme(context, attrs);
        this.initializeView();
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        this.mapView.onCreate(savedInstanceState);
        this.updatePresenterState(savedInstanceState);
    }

    public void onLowMemory() {
        this.mapView.onLowMemory();
    }

    public boolean onBackPressed() {
        return this.instructionView.handleBackPressed();
    }

    public void onSaveInstanceState(Bundle outState) {
        int bottomSheetBehaviorState = this.summaryBehavior == null ? 0 : this.summaryBehavior.getState();
        boolean isWayNameVisible = this.wayNameView.getVisibility() == 0;
        NavigationViewInstanceState navigationViewInstanceState = new NavigationViewInstanceState(bottomSheetBehaviorState, this.recenterBtn.getVisibility(), this.instructionView.isShowingInstructionList(), isWayNameVisible, this.wayNameView.retrieveWayNameText(), this.navigationViewModel.isMuted());
        String instanceKey = this.getContext().getString(R.string.navigation_view_instance_state);
        outState.putParcelable(instanceKey, (Parcelable)navigationViewInstanceState);
        outState.putBoolean(this.getContext().getString(R.string.navigation_running), this.navigationViewModel.isRunning());
        this.mapView.onSaveInstanceState(outState);
        this.saveNavigationMapInstanceState(outState);
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        String instanceKey = this.getContext().getString(R.string.navigation_view_instance_state);
        NavigationViewInstanceState navigationViewInstanceState = (NavigationViewInstanceState)savedInstanceState.getParcelable(instanceKey);
        this.recenterBtn.setVisibility(navigationViewInstanceState.getRecenterButtonVisibility());
        this.wayNameView.setVisibility(navigationViewInstanceState.isWayNameVisible() ? 0 : 4);
        this.wayNameView.updateWayNameText(navigationViewInstanceState.getWayNameText());
        this.resetBottomSheetState(navigationViewInstanceState.getBottomSheetBehaviorState());
        this.updateInstructionListState(navigationViewInstanceState.isInstructionViewVisible());
        this.updateInstructionMutedState(navigationViewInstanceState.isMuted());
        this.mapInstanceState = (NavigationMapboxMapInstanceState)savedInstanceState.getParcelable(MAP_INSTANCE_STATE_KEY);
    }

    public void onDestroy() {
        this.shutdown();
    }

    public void onStart() {
        this.mapView.onStart();
        if (this.navigationMap != null) {
            this.navigationMap.onStart();
        }
    }

    public void onResume() {
        this.mapView.onResume();
    }

    public void onPause() {
        this.mapView.onPause();
    }

    public void onStop() {
        this.mapView.onStop();
        if (this.navigationMap != null) {
            this.navigationMap.onStop();
        }
    }

    public void onMapReady(final MapboxMap mapboxMap) {
        mapboxMap.setStyle(ThemeSwitcher.retrieveMapStyle(this.getContext()), new Style.OnStyleLoaded(){

            public void onStyleLoaded(@NonNull Style style2) {
                NavigationView.this.initializeNavigationMap(NavigationView.this.mapView, mapboxMap);
                NavigationView.this.initializeWayNameListener();
                NavigationView.this.onNavigationReadyCallback.onNavigationReady(NavigationView.this.navigationViewModel.isRunning());
                NavigationView.this.isMapInitialized = true;
            }
        });
    }

    @Override
    public void setSummaryBehaviorState(int state) {
        this.summaryBehavior.setState(state);
    }

    @Override
    public void setSummaryBehaviorHideable(boolean isHideable) {
        this.summaryBehavior.setHideable(isHideable);
    }

    @Override
    public boolean isSummaryBottomSheetHidden() {
        return this.summaryBehavior.getState() == 5;
    }

    @Override
    public void updateCameraTrackingMode(int trackingMode) {
        if (this.navigationMap != null) {
            this.navigationMap.updateCameraTrackingMode(trackingMode);
        }
    }

    @Override
    public void resetCameraPosition() {
        if (this.navigationMap != null) {
            this.navigationMap.resetPadding();
            this.navigationMap.resetCameraPositionWith(0);
        }
    }

    @Override
    public void showRecenterBtn() {
        this.recenterBtn.show();
    }

    @Override
    public void hideRecenterBtn() {
        this.recenterBtn.hide();
    }

    @Override
    public boolean isRecenterButtonVisible() {
        return this.recenterBtn.getVisibility() == 0;
    }

    @Override
    public void drawRoute(DirectionsRoute directionsRoute) {
        if (this.navigationMap != null) {
            this.navigationMap.drawRoute(directionsRoute);
        }
    }

    @Override
    public void addMarker(Point position) {
        if (this.navigationMap != null) {
            this.navigationMap.addMarker(this.getContext(), position);
        }
    }

    public void clearMarkers() {
        if (this.navigationMap != null) {
            this.navigationMap.clearMarkers();
        }
    }

    public boolean isWayNameVisible() {
        return this.wayNameView.getVisibility() == 0;
    }

    @Override
    public void updateWayNameView(@NonNull String wayName) {
        this.wayNameView.updateWayNameText(wayName);
    }

    @Override
    public void updateWayNameVisibility(boolean isVisible) {
        this.wayNameView.updateVisibility(isVisible);
        if (this.navigationMap != null) {
            this.navigationMap.updateWaynameQueryMap(isVisible);
        }
    }

    @Override
    public void takeScreenshot() {
        if (this.navigationMap != null) {
            this.navigationMap.takeScreenshot(new NavigationSnapshotReadyCallback(this, this.navigationViewModel));
        }
    }

    @Override
    public void startCamera(DirectionsRoute directionsRoute) {
        if (this.navigationMap != null) {
            this.navigationMap.startCamera(directionsRoute);
        }
    }

    @Override
    public void resumeCamera(Location location) {
        if (this.navigationMap != null) {
            this.navigationMap.resumeCamera(location);
        }
    }

    @Override
    public void updateNavigationMap(Location location) {
        if (this.navigationMap != null) {
            this.navigationMap.updateLocation(location);
        }
    }

    @Override
    public void updateCameraRouteOverview() {
        if (this.navigationMap != null) {
            int[] padding = this.buildRouteOverviewPadding(this.getContext());
            this.navigationMap.showRouteOverview(padding);
        }
    }

    public void startNavigation(NavigationViewOptions options) {
        this.initializeNavigation(options);
    }

    public void stopNavigation() {
        this.navigationPresenter.onNavigationStopped();
        this.navigationViewModel.stopNavigation();
    }

    public void initialize(OnNavigationReadyCallback onNavigationReadyCallback) {
        this.onNavigationReadyCallback = onNavigationReadyCallback;
        if (!this.isMapInitialized) {
            this.mapView.getMapAsync((OnMapReadyCallback)this);
        } else {
            onNavigationReadyCallback.onNavigationReady(this.navigationViewModel.isRunning());
        }
    }

    public void initialize(OnNavigationReadyCallback onNavigationReadyCallback, @NonNull CameraPosition initialMapCameraPosition) {
        this.onNavigationReadyCallback = onNavigationReadyCallback;
        this.initialMapCameraPosition = initialMapCameraPosition;
        if (!this.isMapInitialized) {
            this.mapView.getMapAsync((OnMapReadyCallback)this);
        } else {
            onNavigationReadyCallback.onNavigationReady(this.navigationViewModel.isRunning());
        }
    }

    @Nullable
    public NavigationMapboxMap retrieveNavigationMapboxMap() {
        return this.navigationMap;
    }

    @Nullable
    public MapboxNavigation retrieveMapboxNavigation() {
        return this.navigationViewModel.retrieveNavigation();
    }

    public NavigationButton retrieveSoundButton() {
        return this.instructionView.retrieveSoundButton();
    }

    public NavigationButton retrieveFeedbackButton() {
        return this.instructionView.retrieveFeedbackButton();
    }

    public NavigationButton retrieveRecenterButton() {
        return this.recenterBtn;
    }

    public NavigationAlertView retrieveAlertView() {
        return this.instructionView.retrieveAlertView();
    }

    private void initializeView() {
        NavigationView.inflate((Context)this.getContext(), (int)R.layout.navigation_view_layout, (ViewGroup)this);
        this.bind();
        this.initializeNavigationViewModel();
        this.initializeNavigationEventDispatcher();
        this.initializeNavigationPresenter();
        this.initializeInstructionListListener();
        this.initializeSummaryBottomSheet();
    }

    private void bind() {
        this.mapView = (MapView)this.findViewById(R.id.navigationMapView);
        this.instructionView = (InstructionView)this.findViewById(R.id.instructionView);
        ViewCompat.setElevation((View)this.instructionView, (float)10.0f);
        this.summaryBottomSheet = (SummaryBottomSheet)this.findViewById(R.id.summaryBottomSheet);
        this.cancelBtn = (ImageButton)this.findViewById(R.id.cancelBtn);
        this.recenterBtn = (RecenterButton)this.findViewById(R.id.recenterBtn);
        this.wayNameView = (WayNameView)this.findViewById(R.id.wayNameView);
        this.routeOverviewBtn = (ImageButton)this.findViewById(R.id.routeOverviewBtn);
    }

    private void initializeNavigationViewModel() {
        try {
            this.navigationViewModel = (NavigationViewModel)ViewModelProviders.of((FragmentActivity)((FragmentActivity)this.getContext())).get(NavigationViewModel.class);
        }
        catch (ClassCastException exception) {
            throw new ClassCastException("Please ensure that the provided Context is a valid FragmentActivity");
        }
    }

    private void initializeSummaryBottomSheet() {
        this.summaryBehavior = BottomSheetBehavior.from((View)this.summaryBottomSheet);
        this.summaryBehavior.setHideable(false);
        this.summaryBehavior.setBottomSheetCallback((BottomSheetBehavior.BottomSheetCallback)new SummaryBottomSheetCallback(this.navigationPresenter, this.navigationViewEventDispatcher));
    }

    private void initializeNavigationEventDispatcher() {
        this.navigationViewEventDispatcher = new NavigationViewEventDispatcher();
        this.navigationViewModel.initializeEventDispatcher(this.navigationViewEventDispatcher);
    }

    private void initializeInstructionListListener() {
        this.instructionView.setInstructionListListener(new NavigationInstructionListListener(this.navigationPresenter, this.navigationViewEventDispatcher));
    }

    private void initializeNavigationMap(MapView mapView, MapboxMap map) {
        this.navigationMap = new NavigationMapboxMap(mapView, map);
        this.navigationMap.updateLocationLayerRenderMode(8);
        if (this.mapInstanceState != null) {
            this.navigationMap.restoreFrom(this.mapInstanceState);
            return;
        }
        if (this.initialMapCameraPosition != null) {
            map.setCameraPosition(this.initialMapCameraPosition);
        }
    }

    private void initializeWayNameListener() {
        NavigationViewWayNameListener wayNameListener = new NavigationViewWayNameListener(this.navigationPresenter);
        this.navigationMap.addOnWayNameChangedListener(wayNameListener);
    }

    private void saveNavigationMapInstanceState(Bundle outState) {
        if (this.navigationMap != null) {
            this.navigationMap.saveStateWith(MAP_INSTANCE_STATE_KEY, outState);
        }
    }

    private void resetBottomSheetState(int bottomSheetState) {
        if (bottomSheetState > 0) {
            boolean isShowing = bottomSheetState == 3;
            this.summaryBehavior.setHideable(!isShowing);
            this.summaryBehavior.setState(bottomSheetState);
        }
    }

    private void updateInstructionListState(boolean visible) {
        if (visible) {
            this.instructionView.showInstructionList();
        } else {
            this.instructionView.hideInstructionList();
        }
    }

    private void updateInstructionMutedState(boolean isMuted) {
        if (isMuted) {
            ((SoundButton)this.instructionView.retrieveSoundButton()).soundFabOff();
        }
    }

    private int[] buildRouteOverviewPadding(Context context) {
        Resources resources = context.getResources();
        int leftRightPadding = (int)resources.getDimension(R.dimen.route_overview_left_right_padding);
        int paddingBuffer = (int)resources.getDimension(R.dimen.route_overview_buffer_padding);
        int instructionHeight = (int)(resources.getDimension(R.dimen.instruction_layout_height) + (float)paddingBuffer);
        int summaryHeight = (int)resources.getDimension(R.dimen.summary_bottomsheet_height);
        return new int[]{leftRightPadding, instructionHeight, leftRightPadding, summaryHeight};
    }

    private boolean isChangingConfigurations() {
        try {
            return ((FragmentActivity)this.getContext()).isChangingConfigurations();
        }
        catch (ClassCastException exception) {
            throw new ClassCastException("Please ensure that the provided Context is a valid FragmentActivity");
        }
    }

    private void initializeNavigationPresenter() {
        this.navigationPresenter = new NavigationPresenter(this);
    }

    private void updatePresenterState(@Nullable Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            String navigationRunningKey = this.getContext().getString(R.string.navigation_running);
            boolean resumeState = savedInstanceState.getBoolean(navigationRunningKey);
            this.navigationPresenter.updateResumeState(resumeState);
        }
    }

    private void initializeNavigation(NavigationViewOptions options) {
        this.establish(options);
        MapboxNavigation navigation = this.navigationViewModel.initialize(options);
        this.initializeNavigationListeners(options, navigation);
        this.setupNavigationMapboxMap(options);
        if (!this.isSubscribed) {
            this.initializeClickListeners();
            this.initializeOnCameraTrackingChangedListener();
            this.subscribeViewModels();
        }
    }

    private void initializeClickListeners() {
        this.cancelBtn.setOnClickListener((View.OnClickListener)new CancelBtnClickListener(this.navigationViewEventDispatcher));
        this.recenterBtn.addOnClickListener(new RecenterBtnClickListener(this.navigationPresenter));
        this.routeOverviewBtn.setOnClickListener((View.OnClickListener)new RouteOverviewBtnClickListener(this.navigationPresenter));
    }

    private void initializeOnCameraTrackingChangedListener() {
        this.onTrackingChangedListener = new NavigationOnCameraTrackingChangedListener(this.navigationPresenter, this.summaryBehavior);
        this.navigationMap.addOnCameraTrackingChangedListener(this.onTrackingChangedListener);
    }

    private void establish(NavigationViewOptions options) {
        LocaleUtils localeUtils = new LocaleUtils();
        this.establishDistanceFormatter(localeUtils, options);
        this.establishTimeFormat(options);
    }

    private void establishDistanceFormatter(LocaleUtils localeUtils, NavigationViewOptions options) {
        String unitType = this.establishUnitType(localeUtils, options);
        String language = this.establishLanguage(localeUtils, options);
        int roundingIncrement = this.establishRoundingIncrement(options);
        DistanceFormatter distanceFormatter = new DistanceFormatter(this.getContext(), language, unitType, roundingIncrement);
        this.instructionView.setDistanceFormatter(distanceFormatter);
        this.summaryBottomSheet.setDistanceFormatter(distanceFormatter);
    }

    private int establishRoundingIncrement(NavigationViewOptions navigationViewOptions) {
        MapboxNavigationOptions mapboxNavigationOptions = navigationViewOptions.navigationOptions();
        return mapboxNavigationOptions.roundingIncrement();
    }

    private String establishLanguage(LocaleUtils localeUtils, NavigationViewOptions options) {
        return localeUtils.getNonEmptyLanguage(this.getContext(), options.directionsRoute().voiceLanguage());
    }

    private String establishUnitType(LocaleUtils localeUtils, NavigationViewOptions options) {
        RouteOptions routeOptions = options.directionsRoute().routeOptions();
        String voiceUnits = routeOptions == null ? null : routeOptions.voiceUnits();
        return localeUtils.retrieveNonNullUnitType(this.getContext(), voiceUnits);
    }

    private void establishTimeFormat(NavigationViewOptions options) {
        int timeFormatType = options.navigationOptions().timeFormatType();
        this.summaryBottomSheet.setTimeFormat(timeFormatType);
    }

    private void initializeNavigationListeners(NavigationViewOptions options, MapboxNavigation navigation) {
        this.navigationMap.addProgressChangeListener(navigation);
        this.navigationViewEventDispatcher.initializeListeners(options, navigation);
    }

    private void setupNavigationMapboxMap(NavigationViewOptions options) {
        this.navigationMap.updateWaynameQueryMap(options.waynameChipEnabled());
    }

    private void subscribeViewModels() {
        this.instructionView.subscribe(this.navigationViewModel);
        this.summaryBottomSheet.subscribe(this.navigationViewModel);
        NavigationViewSubscriber subscriber = new NavigationViewSubscriber(this.navigationPresenter);
        subscriber.subscribe((LifecycleOwner)this.getContext(), this.navigationViewModel);
        this.isSubscribed = true;
    }

    private void shutdown() {
        if (this.navigationMap != null) {
            this.navigationMap.removeOnCameraTrackingChangedListener(this.onTrackingChangedListener);
        }
        this.navigationViewEventDispatcher.onDestroy(this.navigationViewModel.retrieveNavigation());
        this.mapView.onDestroy();
        this.navigationViewModel.onDestroy(this.isChangingConfigurations());
        ImageCreator.getInstance().shutdown();
        this.navigationMap = null;
    }
}

