/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5;

import android.content.Context;
import com.mapbox.android.core.location.LocationEngine;
import com.mapbox.android.core.location.LocationEngineProvider;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.services.android.navigation.v5.location.replay.ReplayRouteLocationEngine;

class LocationEngineConductor {
    private LocationEngine locationEngine;

    LocationEngineConductor() {
    }

    void initializeLocationEngine(Context context, LocationEngine locationEngine, boolean shouldReplayRoute) {
        this.initialize(context, locationEngine, shouldReplayRoute);
    }

    boolean updateSimulatedRoute(DirectionsRoute route) {
        if (this.locationEngine instanceof ReplayRouteLocationEngine) {
            ((ReplayRouteLocationEngine)this.locationEngine).assign(route);
            return true;
        }
        return false;
    }

    LocationEngine obtainLocationEngine() {
        return this.locationEngine;
    }

    private void initialize(Context context, LocationEngine locationEngine, boolean simulateRoute) {
        this.locationEngine = locationEngine != null ? locationEngine : (simulateRoute ? new ReplayRouteLocationEngine() : LocationEngineProvider.getBestLocationEngine((Context)context));
    }
}

