/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.http.MultiValue;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.stubbing.SubEvent;
import java.util.List;
import java.util.stream.Collectors;
import wiremock.com.fasterxml.jackson.annotation.JsonIgnore;

public abstract class MultipleMatchMultiValuePattern
extends MultiValuePattern {
    private static final String AND = " AND ";

    @Override
    public String getName() {
        return this.getValues().stream().map(stringValuePattern -> stringValuePattern.getName() + " " + stringValuePattern.getExpected()).collect(Collectors.joining(AND));
    }

    @Override
    public String getExpected() {
        return "";
    }

    @Override
    public MatchResult match(MultiValue value) {
        if (!value.isPresent()) {
            return MatchResult.of(false, new SubEvent[0]);
        }
        List<MatchResult> matchResults = this.getValues().stream().map(stringValuePattern -> MultipleMatchMultiValuePattern.getBestMatch(stringValuePattern, value.values())).collect(Collectors.toList());
        return MatchResult.aggregate(matchResults);
    }

    @JsonIgnore
    public abstract List<StringValuePattern> getValues();

    @JsonIgnore
    public String getOperator() {
        return "";
    }
}

