/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.ParameterUtils;
import com.github.tomakehurst.wiremock.common.url.PathTemplate;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.TemplateModelDataProviderExtension;
import com.github.tomakehurst.wiremock.extension.responsetemplating.HandlebarsOptimizedTemplate;
import com.github.tomakehurst.wiremock.extension.responsetemplating.RequestTemplateModel;
import com.github.tomakehurst.wiremock.extension.responsetemplating.SystemKeyAuthoriser;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.SystemValueHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.WireMockHelpers;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import wiremock.com.github.jknack.handlebars.EscapingStrategy;
import wiremock.com.github.jknack.handlebars.Handlebars;
import wiremock.com.github.jknack.handlebars.Helper;
import wiremock.com.github.jknack.handlebars.helper.AssignHelper;
import wiremock.com.github.jknack.handlebars.helper.ConditionalHelpers;
import wiremock.com.github.jknack.handlebars.helper.NumberHelper;
import wiremock.com.github.jknack.handlebars.helper.StringHelpers;
import wiremock.com.google.common.cache.Cache;
import wiremock.com.google.common.cache.CacheBuilder;

public class TemplateEngine {
    private final Handlebars handlebars;
    private final Cache<Object, HandlebarsOptimizedTemplate> cache;
    private final Long maxCacheEntries;
    private final List<TemplateModelDataProviderExtension> templateModelDataProviders;

    public static TemplateEngine defaultTemplateEngine() {
        return new TemplateEngine(Collections.emptyMap(), null, null, false, Collections.emptyList());
    }

    public TemplateEngine(Map<String, Helper<?>> helpers, Long maxCacheEntries, Set<String> permittedSystemKeys, boolean escapingDisabled, List<TemplateModelDataProviderExtension> templateModelDataProviders) {
        this.handlebars = escapingDisabled ? new Handlebars().with(EscapingStrategy.NOOP) : new Handlebars();
        this.maxCacheEntries = maxCacheEntries;
        this.templateModelDataProviders = templateModelDataProviders;
        CacheBuilder<Object, Object> cacheBuilder = CacheBuilder.newBuilder();
        if (maxCacheEntries != null) {
            cacheBuilder.maximumSize(maxCacheEntries);
        }
        this.cache = cacheBuilder.build();
        this.addHelpers(helpers, permittedSystemKeys);
    }

    protected TemplateEngine() {
        this.handlebars = null;
        this.maxCacheEntries = null;
        this.cache = null;
        this.templateModelDataProviders = Collections.emptyList();
    }

    private void addHelpers(Map<String, Helper<?>> helpers, Set<String> permittedSystemKeys) {
        for (StringHelpers stringHelpers : StringHelpers.values()) {
            if (stringHelpers.name().equals("now")) continue;
            this.handlebars.registerHelper(stringHelpers.name(), (Helper)stringHelpers);
        }
        for (Enum enum_ : NumberHelper.values()) {
            this.handlebars.registerHelper(enum_.name(), (Helper)((Object)enum_));
        }
        for (Enum enum_ : ConditionalHelpers.values()) {
            this.handlebars.registerHelper(enum_.name(), (Helper)((Object)enum_));
        }
        this.handlebars.registerHelper("assign", (Helper)new AssignHelper());
        for (Enum enum_ : WireMockHelpers.values()) {
            this.handlebars.registerHelper(enum_.name(), (Helper)((Object)enum_));
        }
        this.handlebars.registerHelper("systemValue", (Helper)new SystemValueHelper(new SystemKeyAuthoriser(permittedSystemKeys)));
        for (Map.Entry entry : helpers.entrySet()) {
            this.handlebars.registerHelper((String)entry.getKey(), (Helper)entry.getValue());
        }
    }

    public HandlebarsOptimizedTemplate getTemplate(Object key, String content) {
        if (this.maxCacheEntries != null && this.maxCacheEntries < 1L) {
            return this.getUncachedTemplate(content);
        }
        try {
            return this.cache.get(key, () -> new HandlebarsOptimizedTemplate(this.handlebars, content));
        }
        catch (ExecutionException e) {
            return Exceptions.throwUnchecked(e, HandlebarsOptimizedTemplate.class);
        }
    }

    public HandlebarsOptimizedTemplate getUncachedTemplate(String content) {
        return new HandlebarsOptimizedTemplate(this.handlebars, content);
    }

    public Map<String, Object> buildModelForRequest(ServeEvent serveEvent) {
        LoggedRequest request = serveEvent.getRequest();
        ResponseDefinition responseDefinition = serveEvent.getResponseDefinition();
        Parameters parameters = ParameterUtils.getFirstNonNull(responseDefinition.getTransformerParameters(), Parameters.empty());
        PathTemplate pathTemplate = serveEvent.getStubMapping().getRequest().getUrlMatcher().getPathTemplate();
        Map<String, Object> additionalModelData = this.templateModelDataProviders.stream().map(provider -> provider.provideTemplateModelData(serveEvent).entrySet()).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("parameters", parameters);
        model.put("request", RequestTemplateModel.from(request, pathTemplate));
        model.putAll(additionalModelData);
        return model;
    }

    public long getCacheSize() {
        return this.cache.size();
    }

    public void invalidateCache() {
        this.cache.invalidateAll();
    }

    public Long getMaxCacheEntries() {
        return this.maxCacheEntries;
    }
}

