/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.http.Body;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.matching.BinaryEqualToPattern;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.ValueMatcher;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class MultipartValuePattern
implements ValueMatcher<Request.Part> {
    private final String name;
    private final Map<String, MultiValuePattern> headers;
    private final List<ContentPattern<?>> bodyPatterns;
    private final MatchingType matchingType;

    @JsonCreator
    public MultipartValuePattern(@JsonProperty(value="name") String name, @JsonProperty(value="matchingType") MatchingType type, @JsonProperty(value="headers") Map<String, MultiValuePattern> headers, @JsonProperty(value="bodyPatterns") List<ContentPattern<?>> body) {
        this.name = name;
        this.matchingType = type;
        this.headers = headers;
        this.bodyPatterns = body;
    }

    @JsonIgnore
    public boolean isMatchAny() {
        return this.matchingType == MatchingType.ANY;
    }

    @JsonIgnore
    public boolean isMatchAll() {
        return this.matchingType == MatchingType.ALL;
    }

    @Override
    public MatchResult match(Request.Part value) {
        if (this.headers != null || this.bodyPatterns != null) {
            return MatchResult.aggregate(this.headers != null ? this.matchHeaderPatterns(value) : MatchResult.exactMatch(), this.bodyPatterns != null ? this.matchBodyPatterns(value) : MatchResult.exactMatch());
        }
        return MatchResult.exactMatch();
    }

    @Override
    public MatchResult match(Request request) {
        return this.isMatchAll() ? this.matchAllMultiparts(request) : this.matchAnyMultipart(request);
    }

    private MatchResult matchAllMultiparts(Request request) {
        return request.getParts().stream().allMatch(input -> this.match((Request.Part)input).isExactMatch()) ? MatchResult.exactMatch() : MatchResult.noMatch();
    }

    private MatchResult matchAnyMultipart(Request request) {
        Collection<Request.Part> parts = request.getParts();
        if (parts == null || parts.isEmpty()) {
            return MatchResult.noMatch();
        }
        return parts.stream().anyMatch(input -> this.match((Request.Part)input).isExactMatch()) ? MatchResult.exactMatch() : MatchResult.noMatch();
    }

    public String getName() {
        return this.name;
    }

    public Map<String, MultiValuePattern> getHeaders() {
        return this.headers;
    }

    public MatchingType getMatchingType() {
        return this.matchingType;
    }

    public List<ContentPattern<?>> getBodyPatterns() {
        return this.bodyPatterns;
    }

    private MatchResult matchHeaderPatterns(Request.Part part) {
        if (this.headers != null && !this.headers.isEmpty()) {
            return MatchResult.aggregate(this.headers.entrySet().stream().map(headerPattern -> ((MultiValuePattern)headerPattern.getValue()).match(part.getHeader((String)headerPattern.getKey()))).collect(Collectors.toList()));
        }
        return MatchResult.exactMatch();
    }

    private MatchResult matchBodyPatterns(Request.Part value) {
        return MatchResult.aggregate(this.bodyPatterns.stream().map(bodyPattern -> MultipartValuePattern.matchBody(value, bodyPattern)).collect(Collectors.toList()));
    }

    private static MatchResult matchBody(Request.Part part, ContentPattern<?> bodyPattern) {
        Body body = part.getBody();
        if (body == null) {
            return MatchResult.noMatch();
        }
        if (BinaryEqualToPattern.class.isAssignableFrom(bodyPattern.getClass())) {
            return ((BinaryEqualToPattern)bodyPattern).match(body.asBytes());
        }
        return ((StringValuePattern)bodyPattern).match(body.asString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultipartValuePattern that = (MultipartValuePattern)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.headers, that.headers) && Objects.equals(this.bodyPatterns, that.bodyPatterns) && this.matchingType == that.matchingType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.headers, this.bodyPatterns, this.matchingType});
    }

    public static enum MatchingType {
        ALL,
        ANY;

    }
}

