/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty11;

import com.github.tomakehurst.wiremock.common.JettySettings;
import org.eclipse.jetty.io.NetworkTrafficListener;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.NetworkTrafficServerConnector;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;

public class Jetty11Utils {
    private static final int DEFAULT_ACCEPTORS = 3;
    private static final int DEFAULT_HEADER_SIZE = 32768;

    public static ServerConnector createServerConnector(Server jettyServer, String bindAddress, JettySettings jettySettings, int port, NetworkTrafficListener listener, ConnectionFactory ... connectionFactories) {
        int acceptors = (Integer)jettySettings.getAcceptors().or((Object)3);
        NetworkTrafficServerConnector connector = new NetworkTrafficServerConnector(jettyServer, null, null, null, acceptors, 2, connectionFactories);
        connector.setPort(port);
        connector.setNetworkTrafficListener(listener);
        Jetty11Utils.setJettySettings(jettySettings, (ServerConnector)connector);
        connector.setHost(bindAddress);
        return connector;
    }

    public static void setJettySettings(JettySettings jettySettings, ServerConnector connector) {
        if (jettySettings.getAcceptQueueSize().isPresent()) {
            connector.setAcceptQueueSize(((Integer)jettySettings.getAcceptQueueSize().get()).intValue());
        }
        if (jettySettings.getIdleTimeout().isPresent()) {
            connector.setIdleTimeout(((Long)jettySettings.getIdleTimeout().get()).longValue());
        }
        connector.setShutdownIdleTimeout(((Long)jettySettings.getShutdownIdleTimeout().or((Object)200L)).longValue());
    }

    public static HttpConfiguration createHttpConfig(JettySettings jettySettings) {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setRequestHeaderSize(((Integer)jettySettings.getRequestHeaderSize().or((Object)32768)).intValue());
        httpConfig.setResponseHeaderSize(((Integer)jettySettings.getResponseHeaderSize().or((Object)32768)).intValue());
        httpConfig.setSendDateHeader(false);
        httpConfig.setSendXPoweredBy(false);
        httpConfig.setSendServerVersion(false);
        httpConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer(false));
        return httpConfig;
    }
}

