/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.github.tomakehurst.wiremock.http.MultiValue;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.google.common.base.Objects;
import java.util.Collections;
import java.util.List;

@JsonDeserialize(as=SingleMatchMultiValuePattern.class)
public class SingleMatchMultiValuePattern
extends MultiValuePattern {
    private final StringValuePattern valuePattern;

    @JsonCreator
    public SingleMatchMultiValuePattern(StringValuePattern valuePattern) {
        this.valuePattern = valuePattern;
    }

    @Override
    public MatchResult match(MultiValue multiValue) {
        List<String> values = multiValue.isPresent() ? multiValue.values() : Collections.singletonList(null);
        return SingleMatchMultiValuePattern.getBestMatch(this.valuePattern, values);
    }

    @JsonValue
    public StringValuePattern getValuePattern() {
        return this.valuePattern;
    }

    @Override
    public String getName() {
        return this.valuePattern.getName();
    }

    @Override
    public String getExpected() {
        return this.valuePattern.getExpected();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleMatchMultiValuePattern that = (SingleMatchMultiValuePattern)o;
        return Objects.equal((Object)this.valuePattern, (Object)that.valuePattern);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.valuePattern});
    }
}

