/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.standalone;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.AbstractFileSource;
import com.github.tomakehurst.wiremock.common.BinaryFile;
import com.github.tomakehurst.wiremock.common.ContentTypes;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.JsonException;
import com.github.tomakehurst.wiremock.common.TextFile;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.standalone.MappingFileException;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.stubbing.StubMappingCollection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class RemoteMappingsLoader {
    private final FileSource mappingsFileSource;
    private final FileSource filesFileSource;
    private final WireMock wireMock;

    public RemoteMappingsLoader(FileSource fileSource, WireMock wireMock) {
        this.mappingsFileSource = fileSource.child("mappings");
        this.filesFileSource = fileSource.child("__files");
        this.wireMock = wireMock;
    }

    public void load() {
        List mappingFiles = this.mappingsFileSource.listFilesRecursively().stream().filter(AbstractFileSource.byFileExtension("json")).collect(Collectors.toList());
        for (TextFile mappingFile : mappingFiles) {
            try {
                StubMappingCollection stubCollection = Json.read(mappingFile.readContentsAsString(), StubMappingCollection.class);
                for (StubMapping stubMapping : stubCollection.getMappingOrMappings()) {
                    this.convertBodyFromFileIfNecessary(stubMapping);
                    this.wireMock.register(stubMapping);
                }
            }
            catch (JsonException e) {
                throw new MappingFileException(mappingFile.getPath(), e.getErrors().first().getDetail());
            }
        }
    }

    private void convertBodyFromFileIfNecessary(StubMapping mapping) {
        String bodyFileName = mapping.getResponse().getBodyFileName();
        if (bodyFileName != null) {
            String mimeType;
            ResponseDefinitionBuilder responseDefinitionBuilder = ResponseDefinitionBuilder.like(mapping.getResponse()).withBodyFile(null);
            String extension = StringUtils.substringAfterLast((String)bodyFileName, (String)".");
            if (ContentTypes.determineIsText(extension, mimeType = this.getMimeType(mapping))) {
                TextFile bodyFile = this.filesFileSource.getTextFileNamed(bodyFileName);
                responseDefinitionBuilder.withBody(bodyFile.readContentsAsString());
            } else {
                BinaryFile bodyFile = this.filesFileSource.getBinaryFileNamed(bodyFileName);
                responseDefinitionBuilder.withBody(bodyFile.readContents());
            }
            mapping.setResponse(responseDefinitionBuilder.build());
        }
    }

    private String getMimeType(StubMapping mapping) {
        HttpHeaders responseHeaders = mapping.getResponse().getHeaders();
        if (responseHeaders != null) {
            ContentTypeHeader contentTypeHeader = responseHeaders.getContentTypeHeader();
            return contentTypeHeader != null ? contentTypeHeader.mimeTypePart() : null;
        }
        return null;
    }
}

