/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;

public class NotPattern
extends StringValuePattern {
    private StringValuePattern unexpectedPattern;

    public NotPattern(@JsonProperty(value="not") StringValuePattern unexpectedPattern) {
        super((String)unexpectedPattern.expectedValue);
        this.unexpectedPattern = unexpectedPattern;
    }

    public StringValuePattern getNot() {
        return this.unexpectedPattern;
    }

    @Override
    public MatchResult match(String value) {
        return this.invert(this.unexpectedPattern.match(value));
    }

    private MatchResult invert(final MatchResult matchResult) {
        return new MatchResult(){

            @Override
            public boolean isExactMatch() {
                return !matchResult.isExactMatch();
            }

            @Override
            public double getDistance() {
                if (this.isExactMatch()) {
                    return 0.0;
                }
                return 1.0;
            }
        };
    }
}

