/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.Base64Helper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.FormDataHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsCurrentDateHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsJsonPathHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsRandomValuesHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsSoapHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsXPathHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HostnameHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.ParseDateHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.RegexExtractHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.SizeHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.StringTrimHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.UrlEncodingHelper;
import java.io.IOException;
import java.util.Date;

public enum WireMockHelpers implements Helper<Object>
{
    xPath{
        private HandlebarsXPathHelper helper = new HandlebarsXPathHelper();

        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(String.valueOf(context), options);
        }
    }
    ,
    soapXPath{
        private HandlebarsSoapHelper helper = new HandlebarsSoapHelper();

        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(String.valueOf(context), options);
        }
    }
    ,
    jsonPath{
        private HandlebarsJsonPathHelper helper = new HandlebarsJsonPathHelper();

        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(context, options);
        }
    }
    ,
    randomValue{
        private HandlebarsRandomValuesHelper helper = new HandlebarsRandomValuesHelper();

        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(null, options);
        }
    }
    ,
    hostname{
        private HostnameHelper helper = new HostnameHelper();

        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(context, options);
        }
    }
    ,
    date{
        private HandlebarsCurrentDateHelper helper = new HandlebarsCurrentDateHelper();

        public Object apply(Object context, Options options) throws IOException {
            Date dateContext = context instanceof Date ? (Date)context : null;
            return this.helper.apply(dateContext, options);
        }
    }
    ,
    now{
        private HandlebarsCurrentDateHelper helper = new HandlebarsCurrentDateHelper();

        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(null, options);
        }
    }
    ,
    parseDate{
        private ParseDateHelper helper = new ParseDateHelper();

        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(context.toString(), options);
        }
    }
    ,
    trim{
        private StringTrimHelper helper = new StringTrimHelper();

        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(context, options);
        }
    }
    ,
    base64{
        private Base64Helper helper = new Base64Helper();

        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(context, options);
        }
    }
    ,
    urlEncode{
        private UrlEncodingHelper helper = new UrlEncodingHelper();

        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(context, options);
        }
    }
    ,
    formData{
        private FormDataHelper helper = new FormDataHelper();

        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(context, options);
        }
    }
    ,
    regexExtract{
        private RegexExtractHelper helper = new RegexExtractHelper();

        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(context, options);
        }
    }
    ,
    size{
        private SizeHelper helper = new SizeHelper();

        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(context, options);
        }
    };

}

