/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.github.tomakehurst.wiremock.common.Errors;
import com.github.tomakehurst.wiremock.common.InvalidInputException;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.regex.PatternSyntaxException;

public class JsonException
extends InvalidInputException {
    private static final Function<JsonMappingException.Reference, String> TO_NODE_NAMES = new Function<JsonMappingException.Reference, String>(){

        public String apply(JsonMappingException.Reference input) {
            if (input.getFieldName() != null) {
                return input.getFieldName();
            }
            return String.valueOf(input.getIndex());
        }
    };

    protected JsonException(Errors errors) {
        super(errors);
    }

    public static JsonException fromJackson(JsonMappingException e) {
        Throwable rootCause = JsonException.getRootCause(e);
        String message = rootCause.getMessage();
        if (rootCause instanceof PatternSyntaxException) {
            PatternSyntaxException patternSyntaxException = (PatternSyntaxException)rootCause;
            message = patternSyntaxException.getMessage();
        } else if (rootCause instanceof JsonMappingException) {
            message = ((JsonMappingException)rootCause).getOriginalMessage();
        }
        List nodes = Lists.transform((List)e.getPath(), TO_NODE_NAMES);
        String pointer = '/' + Joiner.on((char)'/').join((Iterable)nodes);
        return new JsonException(Errors.single(10, pointer, "Error parsing JSON", message));
    }

    private static Throwable getRootCause(Throwable e) {
        if (e.getCause() != null) {
            return JsonException.getRootCause(e.getCause());
        }
        return e;
    }
}

