/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.servlet;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.core.FaultInjector;
import com.github.tomakehurst.wiremock.http.ChunkedDribbleDelay;
import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpResponder;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestHandler;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.servlet.BodyChunker;
import com.github.tomakehurst.wiremock.servlet.FaultInjectorFactory;
import com.github.tomakehurst.wiremock.servlet.NoFaultInjectorFactory;
import com.github.tomakehurst.wiremock.servlet.WireMockHttpServletRequestAdapter;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.net.URLDecoder;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WireMockHandlerDispatchingServlet
extends HttpServlet {
    public static final String SHOULD_FORWARD_TO_FILES_CONTEXT = "shouldForwardToFilesContext";
    public static final String MAPPED_UNDER_KEY = "mappedUnder";
    private static final long serialVersionUID = -6602042274260495538L;
    private RequestHandler requestHandler;
    private FaultInjectorFactory faultHandlerFactory;
    private String mappedUnder;
    private Notifier notifier;
    private String wiremockFileSourceRoot = "/";
    private boolean shouldForwardToFilesContext;

    public void init(ServletConfig config) {
        ServletContext context = config.getServletContext();
        this.shouldForwardToFilesContext = this.getFileContextForwardingFlagFrom(config);
        if (context.getInitParameter("WireMockFileSourceRoot") != null) {
            this.wiremockFileSourceRoot = context.getInitParameter("WireMockFileSourceRoot");
        }
        String handlerClassName = config.getInitParameter("RequestHandlerClass");
        String faultInjectorFactoryClassName = config.getInitParameter("FaultHandlerFactoryClass");
        this.mappedUnder = this.getNormalizedMappedUnder(config);
        context.log("RequestHandlerClass from context returned " + handlerClassName + ". Normalized mapped under returned '" + this.mappedUnder + "'");
        this.requestHandler = (RequestHandler)context.getAttribute(handlerClassName);
        this.faultHandlerFactory = faultInjectorFactoryClassName != null ? (FaultInjectorFactory)context.getAttribute(faultInjectorFactoryClassName) : new NoFaultInjectorFactory();
        this.notifier = (Notifier)context.getAttribute("Notifier");
    }

    private String getNormalizedMappedUnder(ServletConfig config) {
        String mappedUnder = config.getInitParameter(MAPPED_UNDER_KEY);
        if (mappedUnder == null) {
            return null;
        }
        if (mappedUnder.endsWith("/")) {
            mappedUnder = mappedUnder.substring(0, mappedUnder.length() - 1);
        }
        return mappedUnder;
    }

    private boolean getFileContextForwardingFlagFrom(ServletConfig config) {
        String flagValue = config.getInitParameter(SHOULD_FORWARD_TO_FILES_CONTEXT);
        return Boolean.valueOf(flagValue);
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        LocalNotifier.set(this.notifier);
        WireMockHttpServletRequestAdapter request = new WireMockHttpServletRequestAdapter(httpServletRequest, this.mappedUnder);
        ServletHttpResponder responder = new ServletHttpResponder(httpServletRequest, httpServletResponse);
        this.requestHandler.handle(request, responder);
    }

    public void applyResponse(Response response, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Fault fault = response.getFault();
        if (fault != null) {
            FaultInjector faultInjector = this.buildFaultInjector(httpServletRequest, httpServletResponse);
            fault.apply(faultInjector);
            httpServletResponse.addHeader(Fault.class.getName(), fault.name());
            return;
        }
        if (response.getStatusMessage() == null) {
            httpServletResponse.setStatus(response.getStatus());
        } else {
            httpServletResponse.setStatus(response.getStatus(), response.getStatusMessage());
        }
        for (HttpHeader header : response.getHeaders().all()) {
            for (String value : header.values()) {
                httpServletResponse.addHeader(header.key(), value);
            }
        }
        if (response.shouldAddChunkedDribbleDelay()) {
            this.writeAndTranslateExceptionsWithChunkedDribbleDelay(httpServletResponse, response.getBody(), response.getChunkedDribbleDelay());
        } else {
            WireMockHandlerDispatchingServlet.writeAndTranslateExceptions(httpServletResponse, response.getBody());
        }
    }

    private FaultInjector buildFaultInjector(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.faultHandlerFactory.buildFaultInjector(httpServletRequest, httpServletResponse);
    }

    private static void writeAndTranslateExceptions(HttpServletResponse httpServletResponse, byte[] content) {
        try {
            ServletOutputStream out = httpServletResponse.getOutputStream();
            out.write(content);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
    }

    private void writeAndTranslateExceptionsWithChunkedDribbleDelay(HttpServletResponse httpServletResponse, byte[] body, ChunkedDribbleDelay chunkedDribbleDelay) {
        try (ServletOutputStream out = httpServletResponse.getOutputStream();){
            if (body.length < 1) {
                this.notifier.error("Cannot chunk dribble delay when no body set");
                out.flush();
                return;
            }
            byte[][] chunkedBody = BodyChunker.chunkBody(body, chunkedDribbleDelay.getNumberOfChunks());
            int chunkInterval = chunkedDribbleDelay.getTotalDuration() / chunkedBody.length;
            for (byte[] bodyChunk : chunkedBody) {
                Thread.sleep(chunkInterval);
                out.write(bodyChunk);
                out.flush();
            }
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void forwardToFilesContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Request request) throws ServletException, IOException {
        String forwardUrl = this.wiremockFileSourceRoot + "__files" + request.getUrl();
        RequestDispatcher dispatcher = httpServletRequest.getRequestDispatcher(URLDecoder.decode(forwardUrl, Charsets.UTF_8.name()));
        dispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    private class ServletHttpResponder
    implements HttpResponder {
        private final HttpServletRequest httpServletRequest;
        private final HttpServletResponse httpServletResponse;

        public ServletHttpResponder(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
            this.httpServletRequest = httpServletRequest;
            this.httpServletResponse = httpServletResponse;
        }

        @Override
        public void respond(Request request, Response response) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            this.httpServletRequest.setAttribute("wiremock.ORIGINAL_REQUEST", (Object)LoggedRequest.createFrom(request));
            try {
                if (response.wasConfigured()) {
                    WireMockHandlerDispatchingServlet.this.applyResponse(response, this.httpServletRequest, this.httpServletResponse);
                } else if (request.getMethod().equals(RequestMethod.GET) && WireMockHandlerDispatchingServlet.this.shouldForwardToFilesContext) {
                    WireMockHandlerDispatchingServlet.this.forwardToFilesContext(this.httpServletRequest, this.httpServletResponse, request);
                } else {
                    this.httpServletResponse.sendError(404);
                }
            }
            catch (Exception e) {
                Exceptions.throwUnchecked(e);
            }
        }
    }
}

