/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating;

import com.github.tomakehurst.wiremock.common.ListOrSingle;
import com.github.tomakehurst.wiremock.common.Urls;
import com.github.tomakehurst.wiremock.extension.responsetemplating.UrlPath;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.MultiValue;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.http.Request;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;

public class RequestTemplateModel {
    private final String url;
    private final UrlPath path;
    private final Map<String, ListOrSingle<String>> query;
    private final Map<String, ListOrSingle<String>> headers;
    private final Map<String, ListOrSingle<String>> cookies;
    private final String body;
    private static final Function<MultiValue, ListOrSingle<String>> TO_TEMPLATE_MODEL = new Function<MultiValue, ListOrSingle<String>>(){

        public ListOrSingle<String> apply(MultiValue input) {
            return ListOrSingle.of(input.values());
        }
    };

    public RequestTemplateModel(String url, UrlPath path, Map<String, ListOrSingle<String>> query, Map<String, ListOrSingle<String>> headers, Map<String, ListOrSingle<String>> cookies, String body) {
        this.url = url;
        this.path = path;
        this.query = query;
        this.headers = headers;
        this.cookies = cookies;
        this.body = body;
    }

    public static RequestTemplateModel from(final Request request) {
        URI url = URI.create(request.getUrl());
        Map<String, QueryParameter> rawQuery = Urls.splitQuery(url);
        Map adaptedQuery = Maps.transformValues(rawQuery, TO_TEMPLATE_MODEL);
        ImmutableMap adaptedHeaders = Maps.toMap(request.getAllHeaderKeys(), (Function)new Function<String, ListOrSingle<String>>(){

            public ListOrSingle<String> apply(String input) {
                return ListOrSingle.of(request.header(input).values());
            }
        });
        Map adaptedCookies = Maps.transformValues(request.getCookies(), (Function)new Function<Cookie, ListOrSingle<String>>(){

            public ListOrSingle<String> apply(Cookie cookie) {
                return ListOrSingle.of(cookie.getValues());
            }
        });
        UrlPath path = new UrlPath(request.getUrl());
        return new RequestTemplateModel(request.getUrl(), path, adaptedQuery, (Map<String, ListOrSingle<String>>)adaptedHeaders, adaptedCookies, request.getBodyAsString());
    }

    public String getUrl() {
        return this.url;
    }

    public UrlPath getPath() {
        return this.path;
    }

    public Map<String, ListOrSingle<String>> getQuery() {
        return this.query;
    }

    public Map<String, ListOrSingle<String>> getHeaders() {
        return this.headers;
    }

    public Map<String, ListOrSingle<String>> getCookies() {
        return this.cookies;
    }

    public String getBody() {
        return this.body;
    }
}

