/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.core;

import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.core.Container;
import com.github.tomakehurst.wiremock.core.MappingsSaver;
import com.github.tomakehurst.wiremock.core.StubServer;
import com.github.tomakehurst.wiremock.extension.ResponseDefinitionTransformer;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.global.GlobalSettingsHolder;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.standalone.MappingsLoader;
import com.github.tomakehurst.wiremock.stubbing.InMemoryStubMappings;
import com.github.tomakehurst.wiremock.stubbing.ListStubMappingsResult;
import com.github.tomakehurst.wiremock.stubbing.ServedStub;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.stubbing.StubMappings;
import com.github.tomakehurst.wiremock.verification.DisabledRequestJournal;
import com.github.tomakehurst.wiremock.verification.FindNearMissesResult;
import com.github.tomakehurst.wiremock.verification.FindRequestsResult;
import com.github.tomakehurst.wiremock.verification.InMemoryRequestJournal;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.NearMiss;
import com.github.tomakehurst.wiremock.verification.NearMissCalculator;
import com.github.tomakehurst.wiremock.verification.RequestJournal;
import com.github.tomakehurst.wiremock.verification.RequestJournalDisabledException;
import com.github.tomakehurst.wiremock.verification.VerificationResult;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;

public class WireMockApp
implements StubServer,
Admin {
    public static final String FILES_ROOT = "__files";
    public static final String ADMIN_CONTEXT_ROOT = "/__admin";
    private final StubMappings stubMappings;
    private final RequestJournal requestJournal;
    private final GlobalSettingsHolder globalSettingsHolder;
    private final boolean browserProxyingEnabled;
    private final MappingsLoader defaultMappingsLoader;
    private final Container container;
    private final MappingsSaver mappingsSaver;
    private final NearMissCalculator nearMissCalculator;

    public WireMockApp(boolean browserProxyingEnabled, MappingsLoader defaultMappingsLoader, MappingsSaver mappingsSaver, boolean requestJournalDisabled, Optional<Integer> maxRequestJournalEntries, Map<String, ResponseDefinitionTransformer> transformers, Map<String, RequestMatcherExtension> requestMatchers, FileSource rootFileSource, Container container) {
        this.browserProxyingEnabled = browserProxyingEnabled;
        this.defaultMappingsLoader = defaultMappingsLoader;
        this.mappingsSaver = mappingsSaver;
        this.globalSettingsHolder = new GlobalSettingsHolder();
        this.requestJournal = requestJournalDisabled ? new DisabledRequestJournal() : new InMemoryRequestJournal(maxRequestJournalEntries);
        this.stubMappings = new InMemoryStubMappings(requestMatchers, this.requestJournal, transformers, rootFileSource);
        this.container = container;
        this.nearMissCalculator = new NearMissCalculator(this.stubMappings, this.requestJournal);
        this.loadDefaultMappings();
    }

    public GlobalSettingsHolder getGlobalSettingsHolder() {
        return this.globalSettingsHolder;
    }

    private void loadDefaultMappings() {
        this.loadMappingsUsing(this.defaultMappingsLoader);
    }

    public void loadMappingsUsing(MappingsLoader mappingsLoader) {
        mappingsLoader.loadMappingsInto(this.stubMappings);
    }

    @Override
    public ServedStub serveStubFor(Request request) {
        ServedStub servedStub = this.stubMappings.serveFor(request);
        if (servedStub.isNoExactMatch()) {
            LoggedRequest loggedRequest = LoggedRequest.createFrom(request);
            if (request.isBrowserProxyRequest() && this.browserProxyingEnabled) {
                return ServedStub.exactMatch(loggedRequest, ResponseDefinition.browserProxy(request));
            }
            this.logUnmatchedRequest(loggedRequest);
        }
        return servedStub;
    }

    private void logUnmatchedRequest(LoggedRequest request) {
        List<NearMiss> nearest = this.nearMissCalculator.findNearestTo(request);
        String message = "Request was not matched:\n" + request;
        if (!nearest.isEmpty()) {
            message = message + "\nClosest match:\n" + nearest.get(0).getStubMapping().getRequest();
        }
        LocalNotifier.notifier().error(message);
    }

    @Override
    public void addStubMapping(StubMapping stubMapping) {
        this.stubMappings.addMapping(stubMapping);
    }

    @Override
    public void removeStubMapping(StubMapping stubMapping) {
        this.stubMappings.removeMapping(stubMapping);
    }

    @Override
    public void editStubMapping(StubMapping stubMapping) {
        this.stubMappings.editMapping(stubMapping);
    }

    @Override
    public ListStubMappingsResult listAllStubMappings() {
        return new ListStubMappingsResult(this.stubMappings.getAll());
    }

    @Override
    public void saveMappings() {
        this.mappingsSaver.saveMappings(this.stubMappings);
    }

    @Override
    public void resetMappings() {
        this.stubMappings.reset();
        this.requestJournal.reset();
    }

    @Override
    public void resetRequests() {
        this.requestJournal.reset();
    }

    @Override
    public void resetToDefaultMappings() {
        this.resetMappings();
        this.loadDefaultMappings();
    }

    @Override
    public void resetScenarios() {
        this.stubMappings.resetScenarios();
    }

    @Override
    public VerificationResult countRequestsMatching(RequestPattern requestPattern) {
        try {
            return VerificationResult.withCount(this.requestJournal.countRequestsMatching(requestPattern));
        }
        catch (RequestJournalDisabledException e) {
            return VerificationResult.withRequestJournalDisabled();
        }
    }

    @Override
    public FindRequestsResult findRequestsMatching(RequestPattern requestPattern) {
        try {
            List<LoggedRequest> requests = this.requestJournal.getRequestsMatching(requestPattern);
            return FindRequestsResult.withRequests(requests);
        }
        catch (RequestJournalDisabledException e) {
            return FindRequestsResult.withRequestJournalDisabled();
        }
    }

    @Override
    public FindRequestsResult findUnmatchedRequests() {
        try {
            ImmutableList requests = FluentIterable.from(this.requestJournal.getAllServedStubs()).filter(ServedStub.NOT_MATCHED).transform(ServedStub.TO_LOGGED_REQUEST).toList();
            return FindRequestsResult.withRequests((List<LoggedRequest>)requests);
        }
        catch (RequestJournalDisabledException e) {
            return FindRequestsResult.withRequestJournalDisabled();
        }
    }

    @Override
    public FindNearMissesResult findNearMissesForUnmatchedRequests() {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        FluentIterable unmatchedServedStubs = FluentIterable.from(this.requestJournal.getAllServedStubs()).filter((Predicate)new Predicate<ServedStub>(){

            public boolean apply(ServedStub input) {
                return input.isNoExactMatch();
            }
        });
        for (ServedStub servedStub : unmatchedServedStubs) {
            listBuilder.addAll(this.nearMissCalculator.findNearestTo(servedStub.getRequest()));
        }
        return new FindNearMissesResult((List<NearMiss>)listBuilder.build());
    }

    @Override
    public FindNearMissesResult findTopNearMissesFor(LoggedRequest loggedRequest) {
        return new FindNearMissesResult(this.nearMissCalculator.findNearestTo(loggedRequest));
    }

    @Override
    public FindNearMissesResult findTopNearMissesFor(RequestPattern requestPattern) {
        return new FindNearMissesResult(this.nearMissCalculator.findNearestTo(requestPattern));
    }

    @Override
    public void updateGlobalSettings(GlobalSettings newSettings) {
        this.globalSettingsHolder.replaceWith(newSettings);
    }

    public int port() {
        return this.container.port();
    }

    @Override
    public void shutdownServer() {
        this.container.shutdown();
    }
}

