/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification;

import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.stubbing.ServedStub;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.stubbing.StubMappings;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.NearMiss;
import com.github.tomakehurst.wiremock.verification.RequestJournal;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import java.util.Comparator;
import java.util.List;

public class NearMissCalculator {
    public static final int NEAR_MISS_COUNT = 3;
    public static final Comparator<NearMiss> NEAR_MISS_ASCENDING_COMPARATOR = new Comparator<NearMiss>(){

        @Override
        public int compare(NearMiss o1, NearMiss o2) {
            return o1.compareTo(o2);
        }
    };
    private final StubMappings stubMappings;
    private final RequestJournal requestJournal;

    public NearMissCalculator(StubMappings stubMappings, RequestJournal requestJournal) {
        this.stubMappings = stubMappings;
        this.requestJournal = requestJournal;
    }

    public List<NearMiss> findNearestTo(final LoggedRequest request) {
        List<StubMapping> allMappings = this.stubMappings.getAll();
        return NearMissCalculator.sortAndTruncate((FluentIterable<NearMiss>)FluentIterable.from(allMappings).transform((Function)new Function<StubMapping, NearMiss>(){

            public NearMiss apply(StubMapping stubMapping) {
                MatchResult matchResult = stubMapping.getRequest().match(request);
                return new NearMiss(request, stubMapping, matchResult);
            }
        }), allMappings.size());
    }

    public List<NearMiss> findNearestTo(final RequestPattern requestPattern) {
        List<ServedStub> servedStubs = this.requestJournal.getAllServedStubs();
        return NearMissCalculator.sortAndTruncate((FluentIterable<NearMiss>)FluentIterable.from(servedStubs).transform((Function)new Function<ServedStub, NearMiss>(){

            public NearMiss apply(ServedStub servedStub) {
                MatchResult matchResult = requestPattern.match(servedStub.getRequest());
                return new NearMiss(servedStub.getRequest(), requestPattern, matchResult);
            }
        }), servedStubs.size());
    }

    private static List<NearMiss> sortAndTruncate(FluentIterable<NearMiss> nearMisses, int originalSize) {
        return nearMisses.toSortedList(NEAR_MISS_ASCENDING_COMPARATOR).subList(0, Math.min(3, originalSize));
    }
}

