/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty9;

import com.github.tomakehurst.wiremock.common.Gzip;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.common.Urls;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.jetty.server.Request;

public class JettyHttpServletRequestAdapter
implements com.github.tomakehurst.wiremock.http.Request {
    private final HttpServletRequest request;
    private byte[] cachedBody;
    private String urlPrefixToRemove;

    public JettyHttpServletRequestAdapter(HttpServletRequest request) {
        this.request = request;
    }

    public JettyHttpServletRequestAdapter(HttpServletRequest request, String urlPrefixToRemove) {
        this.request = request;
        this.urlPrefixToRemove = urlPrefixToRemove;
    }

    @Override
    public String getUrl() {
        String url = this.request.getRequestURI();
        String contextPath = this.request.getContextPath();
        if (!com.google.common.base.Strings.isNullOrEmpty((String)contextPath) && url.startsWith(contextPath)) {
            url = url.substring(contextPath.length());
        }
        if (!com.google.common.base.Strings.isNullOrEmpty((String)this.urlPrefixToRemove) && url.startsWith(this.urlPrefixToRemove)) {
            url = url.substring(this.urlPrefixToRemove.length());
        }
        return this.withQueryStringIfPresent(url);
    }

    @Override
    public String getAbsoluteUrl() {
        return this.withQueryStringIfPresent(this.request.getRequestURL().toString());
    }

    private String withQueryStringIfPresent(String url) {
        return url + (com.google.common.base.Strings.isNullOrEmpty((String)this.request.getQueryString()) ? "" : "?" + this.request.getQueryString());
    }

    @Override
    public RequestMethod getMethod() {
        return RequestMethod.fromString(this.request.getMethod().toUpperCase());
    }

    @Override
    public String getClientIp() {
        String forwardedForHeader = this.getHeader("X-Forwarded-For");
        if (forwardedForHeader != null && forwardedForHeader.length() > 0) {
            return forwardedForHeader;
        }
        return this.request.getRemoteAddr();
    }

    @Override
    public byte[] getBody() {
        if (this.cachedBody == null) {
            try {
                byte[] body = ByteStreams.toByteArray((InputStream)this.request.getInputStream());
                boolean isGzipped = this.hasGzipEncoding() || Gzip.isGzipped(body);
                this.cachedBody = isGzipped ? Gzip.unGzip(body) : body;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return this.cachedBody;
    }

    private boolean hasGzipEncoding() {
        String encodingHeader = this.request.getHeader("Content-Encoding");
        return encodingHeader != null && encodingHeader.contains("gzip");
    }

    @Override
    public String getBodyAsString() {
        return Strings.stringFromBytes(this.getBody());
    }

    @Override
    public String getBodyAsBase64() {
        return Base64.encodeBase64String((byte[])this.getBody());
    }

    @Override
    public String getHeader(String key) {
        ArrayList<String> headerNames = Collections.list(this.request.getHeaderNames());
        for (String currentKey : headerNames) {
            if (!currentKey.toLowerCase().equals(key.toLowerCase())) continue;
            return this.request.getHeader(currentKey);
        }
        return null;
    }

    @Override
    public HttpHeader header(String key) {
        ArrayList<String> headerNames = Collections.list(this.request.getHeaderNames());
        for (String currentKey : headerNames) {
            if (!currentKey.toLowerCase().equals(key.toLowerCase())) continue;
            ArrayList<String> valueList = Collections.list(this.request.getHeaders(currentKey));
            return new HttpHeader(key, (Collection<String>)valueList);
        }
        return HttpHeader.absent(key);
    }

    @Override
    public ContentTypeHeader contentTypeHeader() {
        return this.getHeaders().getContentTypeHeader();
    }

    @Override
    public boolean containsHeader(String key) {
        return this.header(key).isPresent();
    }

    @Override
    public HttpHeaders getHeaders() {
        ArrayList headerList = Lists.newArrayList();
        for (String key : this.getAllHeaderKeys()) {
            headerList.add(this.header(key));
        }
        return new HttpHeaders(headerList);
    }

    @Override
    public Set<String> getAllHeaderKeys() {
        LinkedHashSet<String> headerKeys = new LinkedHashSet<String>();
        Enumeration headerNames = this.request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            headerKeys.add((String)headerNames.nextElement());
        }
        return headerKeys;
    }

    @Override
    public Map<String, Cookie> getCookies() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (javax.servlet.http.Cookie cookie : (javax.servlet.http.Cookie[])MoreObjects.firstNonNull((Object)this.request.getCookies(), (Object)new javax.servlet.http.Cookie[0])) {
            builder.put((Object)cookie.getName(), (Object)JettyHttpServletRequestAdapter.convertCookie(cookie));
        }
        return builder.build();
    }

    private static Cookie convertCookie(javax.servlet.http.Cookie servletCookie) {
        return new Cookie(servletCookie.getValue());
    }

    @Override
    public QueryParameter queryParameter(String key) {
        return (QueryParameter)MoreObjects.firstNonNull((Object)Urls.splitQuery(this.request.getQueryString()).get(key), (Object)QueryParameter.absent(key));
    }

    @Override
    public boolean isBrowserProxyRequest() {
        if (this.request instanceof Request) {
            Request jettyRequest = (Request)this.request;
            return URI.create(jettyRequest.getUri().toString()).isAbsolute();
        }
        return false;
    }

    public String toString() {
        return this.request.toString() + this.getBodyAsString();
    }
}

