/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;

public class ExtensionLoader {
    public static <T> Map<String, T> loadExtension(String ... classNames) {
        return ExtensionLoader.asMap((Iterable<Extension>)FluentIterable.from(Arrays.asList(classNames)).transform(ExtensionLoader.toClasses()).transform(ExtensionLoader.toExtensions()));
    }

    public static Map<String, Extension> load(String ... classNames) {
        return ExtensionLoader.loadExtension(classNames);
    }

    public static Map<String, Extension> asMap(Iterable<Extension> extensions) {
        return Maps.uniqueIndex(extensions, (Function)new Function<Extension, String>(){

            public String apply(Extension extension) {
                return extension.name();
            }
        });
    }

    public static Map<String, Extension> load(Class<? extends Extension> ... classes) {
        return ExtensionLoader.asMap((Iterable<Extension>)FluentIterable.from(Arrays.asList(classes)).transform(ExtensionLoader.toExtensions()));
    }

    private static Function<Class<? extends Extension>, Extension> toExtensions() {
        return new Function<Class<? extends Extension>, Extension>(){

            public Extension apply(Class<? extends Extension> extensionClass) {
                try {
                    return extensionClass.newInstance();
                }
                catch (Exception e) {
                    return Exceptions.throwUnchecked(e, Extension.class);
                }
            }
        };
    }

    private static Function<String, Class<? extends Extension>> toClasses() {
        return new Function<String, Class<? extends Extension>>(){

            public Class<? extends Extension> apply(String className) {
                try {
                    return Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    return Exceptions.throwUnchecked(e, Class.class);
                }
            }
        };
    }

    public static <T extends Extension> Predicate<Map.Entry<String, Extension>> valueAssignableFrom(final Class<T> extensionType) {
        return new Predicate<Map.Entry<String, Extension>>(){

            public boolean apply(Map.Entry<String, Extension> input) {
                return extensionType.isAssignableFrom(input.getValue().getClass());
            }
        };
    }
}

